/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.entity.monster;

import com.tann.dice.gameplay.content.ent.die.side.EnSiBi;
import com.tann.dice.gameplay.content.ent.die.side.EntSide;
import com.tann.dice.gameplay.content.ent.die.side.EntSidesLib;
import com.tann.dice.gameplay.content.ent.type.EntType;
import com.tann.dice.gameplay.content.ent.type.MonsterType;
import com.tann.dice.gameplay.content.ent.type.bill.MTBill;
import com.tann.dice.gameplay.content.ent.type.lib.EntTypeUtils;
import com.tann.dice.gameplay.content.ent.type.lib.MonsterTypeLib;
import com.tann.dice.gameplay.content.gen.pipe.entity.hero.PipeHeroSides;
import com.tann.dice.gameplay.content.gen.pipe.regex.PipeRegexNamed;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.PRNPart;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.PRNSideMulti;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.pos.PRNMid;
import com.tann.dice.util.Tann;
import java.util.ArrayList;
import java.util.List;

public class PipeMonsterSides
extends PipeRegexNamed<MonsterType> {
    static PRNPart MID = new PRNMid("sd");

    public PipeMonsterSides() {
        super(MONSTER, MID, new PRNSideMulti());
    }

    @Override
    public MonsterType example() {
        ArrayList<String> parts = new ArrayList<String>();
        int toAdd = Tann.randomInt(5) + 2;
        for (int i = 0; i < toAdd; ++i) {
            parts.add(PipeHeroSides.rBit());
        }
        String data = Tann.join(":", parts);
        return this.make(MonsterTypeLib.random(), data.split(":"), data);
    }

    @Override
    protected MonsterType internalMake(String[] groups) {
        MonsterType ht = MonsterTypeLib.byName(groups[0]);
        String[] data = groups[1].split(":");
        return this.make(ht, data, groups[1]);
    }

    private MonsterType make(MonsterType mt, String[] data, String unparsed) {
        if (mt.isMissingno()) {
            return null;
        }
        ArrayList<EntSide> replacedSides = new ArrayList<EntSide>();
        for (String datum : data) {
            EntSide es;
            String[] parts = datum.split("-");
            if (!Tann.isInt(parts[0])) {
                return null;
            }
            int index = Integer.parseInt(parts[0]);
            int str = 0;
            if (parts.length == 2) {
                if (!Tann.isInt(parts[1])) {
                    return null;
                }
                str = Integer.parseInt(parts[1]);
            }
            if ((es = this.make(index, str, mt)) == null) {
                return null;
            }
            replacedSides.add(es);
        }
        EntSide[] cpy = new EntSide[6];
        EntType.realToNice(cpy);
        for (int i = 0; i < 6; ++i) {
            cpy[i] = i < replacedSides.size() ? (EntSide)replacedSides.get(i) : mt.size.getBlank();
        }
        EntType.niceToReal(cpy);
        return ((MTBill)((MTBill)EntTypeUtils.copy(mt).name(mt.getName() + MID + unparsed)).sidesRaw(cpy)).bEntType();
    }

    private EntSide make(int index, int val, MonsterType monsterType) {
        if (val > 999 || val < -999) {
            return null;
        }
        List<Object> objs = EntSidesLib.getSizedSides(monsterType.size);
        if (objs.size() <= index) {
            return null;
        }
        Object o = objs.get(index);
        if (o instanceof EntSide) {
            return (EntSide)o;
        }
        if (o instanceof EnSiBi) {
            EnSiBi esb = (EnSiBi)o;
            return esb.val(val);
        }
        return null;
    }
}

