/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.mod;

import com.tann.dice.gameplay.content.gen.pipe.regex.PipeRegexNamed;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.PRNPart;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.pos.PRNPref;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.gameplay.modifier.ModifierLib;
import com.tann.dice.gameplay.modifier.ModifierType;
import com.tann.dice.gameplay.trigger.global.Global;
import com.tann.dice.gameplay.trigger.global.changeHero.GlobalChangeHeroAll;
import com.tann.dice.gameplay.trigger.global.changeHero.GlobalChangeHeroPos;
import com.tann.dice.gameplay.trigger.global.changeHero.effects.ChangeHeroEffect;
import com.tann.dice.gameplay.trigger.global.linked.GlobalPositional;
import com.tann.dice.gameplay.trigger.global.linked.all.GlobalAllEntities;
import com.tann.dice.gameplay.trigger.global.scaffolding.HeroPosition;
import com.tann.dice.gameplay.trigger.personal.Personal;
import com.tann.dice.util.Tann;
import java.util.ArrayList;
import java.util.List;

public class PipeModHeroPos
extends PipeRegexNamed<Modifier> {
    static final PRNPart PREF = new PRNPref("h");

    public PipeModHeroPos() {
        super(PREF, HERO_POSITION, PipeModHeroPos.prnS("\\."), MOD);
    }

    @Override
    protected Modifier internalMake(String[] groups) {
        String posName = groups[0];
        String modName = groups[1];
        HeroPosition hp = HeroPosition.byName(posName);
        Modifier mod = ModifierLib.byName(modName);
        if (mod.isMissingno()) {
            return null;
        }
        return PipeModHeroPos.make(hp, mod);
    }

    public static List<Modifier> makePositionalVariations(List<Modifier> input) {
        ArrayList<Modifier> result = new ArrayList<Modifier>();
        for (Modifier mod : input) {
            if (PipeModHeroPos.getInnerGlobalAll(mod) == null) continue;
            for (HeroPosition hp : HeroPosition.values()) {
                float newTier = PipeModHeroPos.getTier(mod, hp);
                if (Math.abs(Math.abs(newTier - (float)Math.round(newTier)) / newTier) > 0.1f) continue;
                result.add(PipeModHeroPos.make(hp, mod));
            }
        }
        return result;
    }

    private static float getTier(Modifier mod, HeroPosition hp) {
        int num = hp.getRawPosition().length;
        return mod.getFloatTier() / 5.0f * (float)num;
    }

    private static String name(HeroPosition p, String modName) {
        return PREF + p.veryShortName() + "." + modName;
    }

    public static Modifier make(HeroPosition hp, Modifier mod) {
        if (mod.isMissingno()) {
            return null;
        }
        float newTier = PipeModHeroPos.getTier(mod, hp);
        String name = PipeModHeroPos.name(hp, mod.getName());
        Personal p = PipeModHeroPos.getInnerGlobalAll(mod);
        if (p != null) {
            Global[] globals = new Global[]{new GlobalPositional(hp, p)};
            return new Modifier(newTier, name, globals);
        }
        ChangeHeroEffect che = PipeModHeroPos.getInnerGlobalCHE(mod);
        if (che != null) {
            if (mod.getMType() == ModifierType.Unrated) {
                return new Modifier(name, new GlobalChangeHeroPos(hp, che));
            }
            return new Modifier(mod.getFloatTier() * (float)hp.getRawPosition().length / 5.0f, name, new GlobalChangeHeroPos(hp, che));
        }
        return null;
    }

    private static Personal getInnerGlobalAll(Modifier mod) {
        for (Global g : mod.getGlobals()) {
            if (!(g instanceof GlobalAllEntities)) continue;
            GlobalAllEntities gae = (GlobalAllEntities)g;
            if (gae.getPlayer() == null || !gae.getPlayer().booleanValue()) {
                return null;
            }
            return ((GlobalAllEntities)g).personal;
        }
        return null;
    }

    private static ChangeHeroEffect getInnerGlobalCHE(Modifier mod) {
        for (Global g : mod.getGlobals()) {
            if (g instanceof GlobalChangeHeroPos) {
                GlobalChangeHeroPos gae = (GlobalChangeHeroPos)g;
                return gae.getChangeHeroEffect();
            }
            if (!(g instanceof GlobalChangeHeroAll)) continue;
            return ((GlobalChangeHeroAll)g).getChangeHeroEffect();
        }
        return null;
    }

    @Override
    public Modifier example() {
        int attempts = 20;
        ArrayList<Modifier> mods = new ArrayList<Modifier>();
        for (int i = 0; i < 20; ++i) {
            mods.add(ModifierLib.random());
        }
        List<Modifier> potential = PipeModHeroPos.makePositionalVariations(mods);
        if (potential.size() > 0) {
            return Tann.random(potential);
        }
        return null;
    }

    @Override
    public boolean canGenerate(boolean wild) {
        return true;
    }

    @Override
    protected Modifier generateInternal(boolean wild) {
        if (wild) {
            return this.example();
        }
        return PipeModHeroPos.make(Tann.random(HeroPosition.values()), ModifierLib.byName(Tann.pick("ascend", "level up", "delevel", "missing")));
    }

    @Override
    public float getRarity(boolean wild) {
        return wild ? 1.0f : 0.7f;
    }

    @Override
    public boolean skipAPI() {
        return true;
    }
}

