/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.mod;

import com.tann.dice.gameplay.content.gen.pipe.mod.PipeModTurn;
import com.tann.dice.gameplay.content.gen.pipe.regex.PipeRegexNamed;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.gameplay.modifier.ModifierLib;
import com.tann.dice.gameplay.trigger.global.scaffolding.turnRequirement.GlobalTurnRequirement;
import com.tann.dice.gameplay.trigger.global.scaffolding.turnRequirement.TurnRequirementEveryN;
import com.tann.dice.util.Tann;

public class PipeModTurnEvery
extends PipeRegexNamed<Modifier> {
    static final String PREF = "et";

    public PipeModTurnEvery() {
        super(PipeModTurnEvery.prnS(PREF), DIGIT, PipeModTurnEvery.prnS("\\."), MOD);
    }

    @Override
    public Modifier example() {
        for (int i = 0; i < 100; ++i) {
            Modifier m = PipeModTurnEvery.make(Tann.randomInt(2, 6), ModifierLib.random());
            if (m == null) continue;
            return m;
        }
        return ModifierLib.getMissingno();
    }

    @Override
    protected Modifier internalMake(String[] groups) {
        String sLev = groups[0];
        String sMod = groups[1];
        if (!Tann.isInt(sLev)) {
            return null;
        }
        return PipeModTurnEvery.make(Integer.parseInt(sLev), ModifierLib.byName(sMod));
    }

    private static Modifier make(int everyN, Modifier mod) {
        if (everyN <= 1 || !PipeModTurn.validateModifier(mod)) {
            return null;
        }
        float tier = (float)mod.getTier() * PipeModTurnEvery.levelMult(everyN);
        return new Modifier(tier, PREF + everyN + "." + mod.getName(), new GlobalTurnRequirement(new TurnRequirementEveryN(everyN), mod.getSingleGlobalOrNull()));
    }

    private static float levelMult(int level) {
        if (level < 1) {
            return Float.NaN;
        }
        if (level == 1) {
            return 1.0f;
        }
        return (float)((double)(1.0f / (float)level) * Math.pow(0.9f, level + 1));
    }

    @Override
    public boolean canGenerate(boolean wild) {
        return wild;
    }

    @Override
    protected Modifier generateInternal(boolean wild) {
        return this.example();
    }

    @Override
    public boolean skipAPI() {
        return true;
    }
}

