/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.item;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.tann.dice.gameplay.content.ent.Ent;
import com.tann.dice.gameplay.content.ent.Hero;
import com.tann.dice.gameplay.content.gen.pipe.item.PipeItem;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.PipeMetaIndexed;
import com.tann.dice.gameplay.context.DungeonContext;
import com.tann.dice.gameplay.effect.eff.keyword.Keyword;
import com.tann.dice.gameplay.effect.targetable.ability.Ability;
import com.tann.dice.gameplay.modifier.modBal.TierUtils;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.Choosable;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.ChoosableType;
import com.tann.dice.gameplay.progress.chievo.unlock.Unlockable;
import com.tann.dice.gameplay.progress.stats.stat.Stat;
import com.tann.dice.gameplay.progress.stats.stat.pickRate.PickStat;
import com.tann.dice.gameplay.trigger.Collision;
import com.tann.dice.gameplay.trigger.Trigger;
import com.tann.dice.gameplay.trigger.global.Global;
import com.tann.dice.gameplay.trigger.global.chance.GlobalRarity;
import com.tann.dice.gameplay.trigger.personal.Personal;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.screens.dungeon.panels.book.views.ItemLedgerView;
import com.tann.dice.screens.dungeon.panels.entPanel.choosablePanel.ItemPanel;
import com.tann.dice.statics.Images;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.ImageActor;
import com.tann.dice.util.Tann;
import com.tann.dice.util.lang.Words;
import com.tann.dice.util.ui.TextWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Item
implements Unlockable,
Choosable {
    private final int tier;
    private final String name;
    private final String description;
    private final List<Personal> personals;
    private final boolean hidden;
    private final boolean confirmed;
    private final float chance;
    private final TextureRegion image;
    boolean isNew = false;
    final long ignoredBits = Collision.PLAYER_KEYWORD | Collision.PHYSICAL_DAMAGE;

    public Item(int tier, String name, TextureRegion image, List<Personal> triggers, String description, boolean hidden, boolean confirmed) {
        this.tier = tier;
        this.name = name;
        this.personals = triggers;
        this.hidden = hidden;
        this.description = description;
        this.confirmed = confirmed;
        this.image = image;
        this.chance = this.calculateChance();
    }

    public String getImagePath() {
        return "item/" + this.getImageName();
    }

    public String getImageName() {
        return this.name.replaceAll("[ ':]", "-").toLowerCase();
    }

    public boolean usableBy(Ent ent) {
        return ent instanceof Hero;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public boolean isForceEquip() {
        for (Personal t : this.getPersonalTriggers()) {
            if (!t.forceEquip()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Actor makeUnlockActor(boolean big) {
        if (!big) {
            ItemLedgerView iav = new ItemLedgerView(this, ItemLedgerView.EquipSeenState.Seen);
            iav.addBasicListener();
            return iav;
        }
        return new ItemPanel(this, false);
    }

    @Override
    public TextureRegion getAchievementIcon() {
        return this.image;
    }

    @Override
    public String getAchievementIconString() {
        return "[grey]I";
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getTierString() {
        String col = this.tier < 0 ? "[purple]" : "[grey]";
        return col + Words.getTierString(Math.abs(this.getTier())) + "[cu]";
    }

    @Override
    public ChoosableType getType() {
        return ChoosableType.Item;
    }

    @Override
    public void onChoose(DungeonContext dc, int index) {
        if (!dc.allowInventory()) {
            Sounds.playSound(Sounds.error);
            return;
        }
        dc.getParty().addItem(this);
        dc.getStatsManager().pickDelta(this, true);
        dc.setCheckedItems(false);
        this.setNew(true);
    }

    @Override
    public void onReject(DungeonContext dc) {
        dc.getStatsManager().pickDelta(this, false);
    }

    @Override
    public Actor makeChoosableActor(boolean big, int index) {
        return new ItemPanel(this, big);
    }

    @Override
    public String describe() {
        return "item";
    }

    private float calculateChance() {
        ArrayList<Global> globals = new ArrayList<Global>();
        for (Personal pt : this.personals) {
            Global gt = pt.getGlobalFromPersonalTrigger();
            if (gt == null) continue;
            globals.add(gt);
        }
        return GlobalRarity.listChance(globals);
    }

    @Override
    public float chance() {
        return this.chance;
    }

    public boolean hasBadEquipArt() {
        for (Personal pt : this.getPersonalTriggers()) {
            Actor b = pt.makePanelActor(true);
            if (b != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public float getModTier() {
        return TierUtils.itemModTier(this.getTier());
    }

    public List<Personal> getPersonalTriggers() {
        return this.personals;
    }

    @Override
    public String getName() {
        return this.getName(false);
    }

    public String getName(boolean display) {
        if (!display) {
            return this.name;
        }
        String tmp = this.name;
        for (int i = 0; i < this.personals.size(); ++i) {
            tmp = this.personals.get(i).affectItemName(tmp);
        }
        return tmp;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public TextureRegion getImage() {
        return this.image;
    }

    public static Color getIdCol() {
        return Colours.grey;
    }

    public List<Keyword> getReferencedKeywords() {
        ArrayList<Keyword> result = new ArrayList<Keyword>();
        for (Personal pt : this.personals) {
            result.addAll(pt.getReferencedKeywords());
        }
        Tann.uniquify(result);
        return result;
    }

    @Override
    public boolean encountered(Map<String, Stat> allMergedStats) {
        return this.getPicks(allMergedStats, false) + this.getPicks(allMergedStats, true) > 0;
    }

    @Override
    public int getPicks(Map<String, Stat> allMergedStats, boolean reject) {
        String tag = PickStat.nameFor(this);
        Stat s = allMergedStats.get(tag);
        if (s == null) {
            return 0;
        }
        return PickStat.val(s, reject);
    }

    @Override
    public long getCollisionBits() {
        long result = this.getCollisionBitsBasic();
        return result - (result & this.ignoredBits);
    }

    public long getCollisionBitsIncludingGenericTransformed() {
        long result = 0L;
        for (int j = 0; j < this.personals.size(); ++j) {
            result |= this.personals.get(j).getCollisionBits(true);
        }
        if ((result & Collision.GENERIC_ALL_SIDES_HERO) != 0L) {
            result |= Collision.ALL_SIDES_HERO_COMPOSITE;
        }
        return result;
    }

    private long getCollisionBitsBasic() {
        long result = 0L;
        for (int j = 0; j < this.personals.size(); ++j) {
            result |= this.personals.get(j).getCollisionBits(true);
        }
        if (this.tier < -1) {
            result |= Collision.VERY_BAD_ITEM;
        }
        return result;
    }

    public boolean isMissingno() {
        return this == PipeItem.getMissingno();
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    @Override
    public String getSaveString() {
        String tiny;
        if (DungeonScreen.tinyPasting && (tiny = PipeMetaIndexed.tinyName(this)) != null && tiny.length() <= this.getName(false).length()) {
            return tiny;
        }
        return this.getName(false);
    }

    @Override
    public boolean isPositive() {
        return this.tier >= 0;
    }

    @Override
    public Color getColour() {
        return Item.getIdCol();
    }

    public Ability getAbility() {
        List<Personal> triggers = this.getPersonalTriggers();
        int triggersSize = triggers.size();
        for (int i = 0; i < triggersSize; ++i) {
            Personal pt = triggers.get(i);
            if (pt.getAbility() == null) continue;
            return pt.getAbility();
        }
        return null;
    }

    public Actor makeImageActor() {
        if (this.getAbility() == null) {
            return new ImageActor(this.image);
        }
        return Item.makeAbilityItemActor(this.getAbility());
    }

    public static Actor makeAbilityItemActor(Ability ability) {
        Group g = Tann.makeGroup(14, 14);
        Actor center = ability.useImage() ? new ImageActor(ability.getImage()) : new TextWriter(TextWriter.getTag(ability.getIdCol()) + ability.getTitle().charAt(0));
        g.addActor(center);
        Tann.center(center);
        ImageActor border = new ImageActor(Images.itemAbilityBorder, ability.getIdCol());
        g.addActor(border);
        return g;
    }

    public boolean canEquip(Hero h) {
        if (h == null) {
            return false;
        }
        for (Personal pt : this.getPersonalTriggers()) {
            if (!pt.unequip(h)) continue;
            return false;
        }
        return true;
    }

    public boolean isPotion() {
        return this.getName(false).toLowerCase().contains("potion");
    }

    public boolean isMultiplable(boolean liberal) {
        return Trigger.checkMultiplability(this.personals, liberal);
    }

    public Personal getSinglePersonalOrNull() {
        Personal result = null;
        List<Personal> globs = this.getPersonalTriggers();
        for (int i = 0; i < globs.size(); ++i) {
            Personal g = globs.get(i);
            if (g.metaOnly()) continue;
            if (result != null) {
                return null;
            }
            result = g;
        }
        return result;
    }
}

