/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.item;

import com.tann.dice.gameplay.content.gen.pipe.Pipe;
import com.tann.dice.gameplay.content.gen.pipe.item.PipeItem;
import com.tann.dice.gameplay.content.gen.pipe.item.PipeItemGeneratedTiered;
import com.tann.dice.gameplay.content.item.ItBill;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.content.item.blob.ItemBlob;
import com.tann.dice.gameplay.context.DungeonContext;
import com.tann.dice.gameplay.effect.eff.keyword.Keyword;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.gameplay.modifier.modBal.TierUtils;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.Choosable;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.ChoosableUtils;
import com.tann.dice.gameplay.progress.chievo.unlock.UnUtil;
import com.tann.dice.gameplay.trigger.global.Global;
import com.tann.dice.gameplay.trigger.global.item.GlobalStartWithItem;
import com.tann.dice.util.Tann;
import com.tann.dice.util.bsRandom.Supplier;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public abstract class ItemLib {
    public static final int MIN_QUALITY = -7;
    public static final int MAX_QUALITY = 20;
    private static List<Item> all = new ArrayList<Item>();

    public static void init() {
        all = new ArrayList<Item>();
        ItemLib.addAll(ItemBlob.makeAll());
        PipeItem.init(all);
    }

    private static void addAll(List<ItBill> bill) {
        for (ItBill itBill : bill) {
            ItemLib.add(itBill);
        }
    }

    private static void add(ItBill bill) {
        ItemLib.add(bill.bItem());
    }

    private static void add(Item add) {
        String name = add.getName(false).toLowerCase();
        for (Item e : all) {
            if (!e.getName(false).toLowerCase().equals(name)) continue;
            System.err.println("Wuhoh, duplicate item with name " + add.getName(false));
            return;
        }
        all.add(add);
    }

    public static boolean collides(List<Item> att) {
        for (int i = 0; i < att.size(); ++i) {
            for (int j = i + 1; j < att.size(); ++j) {
                if (!ChoosableUtils.collides((Choosable)att.get(i), att.get(j))) continue;
                return true;
            }
        }
        return false;
    }

    public static List<Item> randomWithExactQuality(int numItems, int itemTier, DungeonContext dc) {
        return ItemLib.randomWithExactQuality(numItems, itemTier, dc, null);
    }

    public static List<Item> randomWithExactQuality(int numItems, int itemTier, long onlyBits) {
        return ItemLib.randomWithExactQuality(numItems, itemTier, new ArrayList<Item>(), new ArrayList<Item>(), onlyBits);
    }

    public static List<Item> randomWithExactQuality(int numItems, int itemTier, DungeonContext dc, List<Item> bannedItems) {
        List<Item> ownedItems = dc.getParty().getItems(null);
        if (bannedItems != null) {
            ownedItems.addAll(bannedItems);
        }
        return ItemLib.randomWithExactQuality(numItems, itemTier, ownedItems, dc);
    }

    private static List<Item> randomWithExactQuality(int numItems, int itemTier, List<Item> owned, DungeonContext dc) {
        long bannedBitsFromContext = dc.getBannedCollisionBits();
        List<Item> base = ItemLib.getAllItemsWithQuality(itemTier, false, bannedBitsFromContext);
        for (Global modifierGlobal : dc.getModifierGlobals()) {
            modifierGlobal.affectItemOptions(base, itemTier);
        }
        List<Item> picked = Tann.getSelectiveRandom(base, numItems, PipeItem.getMissingno(), owned, dc.makeSeenItems());
        return ItemLib.rweqInternalFinalTransformationsAfterPicked(itemTier, bannedBitsFromContext, picked);
    }

    private static List<Item> randomWithExactQuality(int numItems, int itemTier, List<Item> owned, List<Item> alreadySeen, long bannedBitsFromContext) {
        List<Item> base = ItemLib.getAllItemsWithQuality(itemTier, false, bannedBitsFromContext);
        List<Item> picked = Tann.getSelectiveRandom(base, numItems, PipeItem.getMissingno(), owned, alreadySeen);
        return ItemLib.rweqInternalFinalTransformationsAfterPicked(itemTier, bannedBitsFromContext, picked);
    }

    private static List<Item> rweqInternalFinalTransformationsAfterPicked(int itemTier, long bannedBitsFromContext, List<Item> result) {
        int i;
        for (i = 0; i < result.size(); ++i) {
            Item attempt;
            if (result.get(i).isMissingno()) {
                result.set(i, PipeItem.makeFallback(itemTier, bannedBitsFromContext));
            }
            if (!PipeItemGeneratedTiered.shouldGenerateRandom() || (attempt = PipeItem.makeTieredMaybeNull(itemTier, bannedBitsFromContext)) == null) continue;
            result.set(i, attempt);
        }
        if (itemTier >= 10) {
            for (i = 0; i < result.size() / 2; ++i) {
                result.set(i, PipeItem.makeFallback(itemTier, bannedBitsFromContext));
            }
        }
        return result;
    }

    public static Item random() {
        return Tann.random(all);
    }

    public static Item random(Random r) {
        return all.get(r.nextInt(all.size()));
    }

    public static int getStandardItemQualityFor(int levelNumber) {
        return ItemLib.getStandardItemQualityFor(levelNumber, 0);
    }

    public static int getStandardItemQualityFor(int levelNumber, int bonusQuality) {
        int extra = 0;
        int above20 = levelNumber - 21;
        if (above20 >= 0) {
            extra = above20 / 2;
        }
        return levelNumber / 2 + bonusQuality + extra;
    }

    public static Item byName(String name) {
        return PipeItem.fetch(name);
    }

    public static Item[] byeNames(String ... items) {
        Item[] rslt = new Item[items.length];
        for (int i = 0; i < items.length; ++i) {
            rslt[i] = ItemLib.byName(items[i]);
        }
        return rslt;
    }

    public static List<Item> deserialise(List<String> strings) {
        ArrayList<Item> result = new ArrayList<Item>();
        for (String s : strings) {
            result.add(ItemLib.byName(s));
        }
        return result;
    }

    public static List<String> serialise(List<Item> items) {
        ArrayList<String> result = new ArrayList<String>();
        for (Item e : items) {
            result.add(e.getName(false));
        }
        return result;
    }

    public static List<Item> getAllItemsWithQuality(int quality) {
        return ItemLib.getAllItemsWithQuality(quality, false);
    }

    public static List<Item> getAllItemsWithQuality(int quality, boolean allowLocked) {
        return ItemLib.getAllItemsWithQuality(quality, allowLocked, 0L);
    }

    public static List<Item> getAllItemsWithQuality(int quality, boolean allowLocked, long bannedBits) {
        ArrayList<Item> results = new ArrayList<Item>();
        for (Item e : all) {
            if (ChoosableUtils.collides((Choosable)e, bannedBits) || e.getTier() != quality || !allowLocked && UnUtil.isLocked(e)) continue;
            results.add(e);
        }
        return results;
    }

    public static int getNumNormalItems() {
        int total = 0;
        for (Item e : all) {
            if (e.isHidden()) continue;
            ++total;
        }
        return total;
    }

    public static List<Item> getMasterCopy() {
        return new ArrayList<Item>(all);
    }

    public static Modifier makeBlessingMulti(String name, Item ... eqs) {
        float tier = 0.0f;
        for (Item e : eqs) {
            tier += TierUtils.itemModTier(e.getTier());
        }
        return new Modifier(tier *= 0.9f, name, new GlobalStartWithItem(eqs));
    }

    public static List<Item> search(String start) {
        start = start.toLowerCase();
        ArrayList<Item> result = new ArrayList<Item>();
        for (Item i : all) {
            if (!i.getName(false).toLowerCase().contains(start)) continue;
            result.add(i);
        }
        return result;
    }

    public static Item[] getAllPotions() {
        ArrayList<Item> result = new ArrayList<Item>();
        for (Item i : all) {
            if (!i.isPotion()) continue;
            result.add(0, i);
        }
        return result.toArray(new Item[0]);
    }

    public static List<Keyword> getAllKeywordRefrences() {
        ArrayList<Keyword> ks = new ArrayList<Keyword>();
        for (Item item : all) {
            ks.addAll(item.getReferencedKeywords());
        }
        return ks;
    }

    public static List<String> names(List<Item> toulouse) {
        ArrayList<String> strings = new ArrayList<String>();
        for (Item item : toulouse) {
            strings.add(item.getName());
        }
        return strings;
    }

    public static Supplier<Item> makeSupplier() {
        return new Supplier<Item>(){

            @Override
            public Item supply() {
                return ItemLib.random();
            }
        };
    }

    public static Item checkedByName(String text) {
        Pipe.setupChecks();
        Item i = ItemLib.byName(text);
        Pipe.disableChecks();
        return i;
    }
}

