/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.effect.targetable.ability;

import com.badlogic.gdx.graphics.Color;
import com.tann.dice.gameplay.content.ent.type.HeroType;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeLib;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeUtils;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.content.item.ItemLib;
import com.tann.dice.gameplay.effect.targetable.ability.Ability;
import com.tann.dice.gameplay.effect.targetable.ability.spell.Spell;
import com.tann.dice.gameplay.effect.targetable.ability.spell.SpellLib;
import com.tann.dice.gameplay.effect.targetable.ability.tactic.Tactic;
import com.tann.dice.gameplay.effect.targetable.ability.tactic.TacticUtils;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Tann;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AbilityUtils {
    public static final Color TACTIC_COL = Colours.yellow;
    private static List<Ability> all;
    private static Map<String, Ability> map;
    public static Map<Ability, Float> abilityStrengthMap;

    public static List<Ability> getAll() {
        ArrayList<Ability> result = new ArrayList<Ability>();
        result.addAll(SpellLib.makeAllSpellsList());
        result.addAll(TacticUtils.makeAll(true));
        return result;
    }

    public static void init() {
        Ability s;
        abilityStrengthMap = new HashMap<Ability, Float>();
        map = new HashMap<String, Ability>();
        all = AbilityUtils.getAll();
        for (int i = 0; i < all.size(); ++i) {
            map.put(all.get(i).getTitle().toLowerCase(), all.get(i));
        }
        for (HeroType ht : HeroTypeLib.getMasterCopy()) {
            s = ht.getAbility();
            if (s == null) continue;
            AbilityUtils.addAbility(s, ht.getTier());
        }
        for (Item i : ItemLib.getMasterCopy()) {
            s = i.getAbility();
            if (s == null) continue;
            AbilityUtils.addAbility(s, AbilityUtils.itemTierToHeroTierFactor(i.getTier()));
        }
        ArrayList<Ability> abs = new ArrayList<Ability>();
        abs.addAll(SpellLib.makeAllSpellsList());
        abs.addAll(TacticUtils.makeAll(true));
        for (Ability ab : abs) {
            if (all.contains(ab)) continue;
            AbilityUtils.addAbility(ab, Float.NaN);
        }
    }

    private static float itemTierToHeroTierFactor(float itemTier) {
        return (itemTier + 1.0f) / 2.0f;
    }

    public static float heroTierFactorToItemTier(float heroTier) {
        return heroTier * 2.0f - 1.0f;
    }

    public static Ability byName(String name) {
        if ((name = name.toLowerCase()).startsWith("sb") || name.startsWith("sr") || name.startsWith("tn")) {
            return HeroTypeUtils.byName(name.substring(1)).getAbility();
        }
        return map.get(name.toLowerCase());
    }

    public static Spell spellByName(String name) {
        Ability a = AbilityUtils.byName(name);
        if (a instanceof Spell) {
            return (Spell)a;
        }
        return null;
    }

    public static Tactic tacticByName(String name) {
        Ability a = AbilityUtils.byName(name);
        if (a instanceof Tactic) {
            return (Tactic)a;
        }
        return null;
    }

    public static float likeFromHeroTier(Ability ab) {
        Float f = abilityStrengthMap.get(ab);
        if (f == null) {
            return Float.NaN;
        }
        return f.floatValue();
    }

    private static void addAbility(Ability a, float v) {
        all.add(a);
        map.put(a.getTitle().toLowerCase(), a);
        abilityStrengthMap.put(a, Float.valueOf(v));
    }

    public static Ability random() {
        return Tann.random(all);
    }
}

