/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.effect.targetable.ability.generation;

import com.tann.dice.gameplay.content.ent.die.side.EntSide;
import com.tann.dice.gameplay.content.ent.die.side.EntSidesLib;
import com.tann.dice.gameplay.content.ent.die.side.blob.ESB;
import com.tann.dice.gameplay.content.ent.type.HeroCol;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeUtils;
import com.tann.dice.gameplay.content.gen.pipe.entity.hero.generate.PipeHeroGenerated;
import com.tann.dice.gameplay.effect.eff.Eff;
import com.tann.dice.gameplay.effect.eff.EffBill;
import com.tann.dice.gameplay.effect.eff.EffType;
import com.tann.dice.gameplay.effect.eff.TargetingType;
import com.tann.dice.gameplay.effect.eff.conditionalBonus.conditionalRequirement.ConditionalRequirement;
import com.tann.dice.gameplay.effect.eff.keyword.Keyword;
import com.tann.dice.gameplay.effect.targetable.ability.spell.Spell;
import com.tann.dice.gameplay.effect.targetable.ability.spell.SpellUtils;
import com.tann.dice.statics.ImageUtils;
import com.tann.dice.util.Tann;
import com.tann.dice.util.WhiskerRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class SpellGeneration {
    public static Spell generate(int tier, long seed, HeroCol col) {
        WhiskerRandom r = new WhiskerRandom(seed);
        float tierManaVal = EffType.Mana.getEffectTier(tier, 1.0f, true, null);
        int cost = r.nextInt(r.nextInt(6) + 1) + 1;
        float SCL_FAC = 1.05f;
        float scaleCalc = (float)(Math.pow(1.05f, cost) - 0.04999995231628418);
        float calculatedEffect = tierManaVal * (float)cost * scaleCalc;
        Eff e = SpellGeneration.getSpellEffect(calculatedEffect, r, tier, col);
        return new Spell(e, "s" + col.shortName() + "" + tier + "." + PipeHeroGenerated.getGeneratedString(seed), ImageUtils.loadExt("ability/spell/special/generated"), cost);
    }

    public static Spell generateMulti(long seed) {
        int tier = 1;
        WhiskerRandom r = new WhiskerRandom(seed);
        int cost = 3;
        Eff e = SpellGeneration.getSpellEffect(Tann.random(10.0f), r, tier, Tann.random(HeroCol.basics()));
        EffBill eb = new EffBill(e);
        eb.bonusUntargeted(SpellGeneration.getBonusUntargetedSpellEffect());
        return new Spell(eb.bEff(), "sm" + tier + "-" + PipeHeroGenerated.getGeneratedString(seed), ImageUtils.loadExt("ability/spell/special/generated"), cost);
    }

    private static Eff getBonusUntargetedSpellEffect() {
        int val = Tann.randomInt(1, 5);
        List<EntSide> sds = EntSidesLib.getAllSidesWithValue();
        Collections.shuffle(sds);
        block7: for (EntSide entSide : sds) {
            Eff e = (entSide = entSide.withValue(val)).getBaseEffect();
            if (e.needsTarget()) continue;
            switch (e.getTargetingType()) {
                case Self: {
                    continue block7;
                }
            }
            switch (e.getType()) {
                case Blank: 
                case Mana: 
                case Reroll: {
                    continue block7;
                }
                case Summon: {
                    if (!(Math.random() > 0.2)) break;
                    continue block7;
                }
            }
            return e;
        }
        return new EffBill().mana(489).bEff();
    }

    public static Eff getSpellEffect(float val, Random r, int tier, HeroCol col) {
        HeroCol sideCol = col;
        if (sideCol == HeroCol.blue) {
            HeroCol heroCol = sideCol = r.nextBoolean() ? HeroCol.orange : HeroCol.yellow;
        }
        if (sideCol == HeroCol.red) {
            sideCol = r.nextBoolean() ? HeroCol.grey : HeroCol.red;
        }
        ArrayList<EntSide> sides = new ArrayList<EntSide>(HeroTypeUtils.getSidesWithColour(sideCol, true, false));
        Collections.shuffle(sides, r);
        Eff best = ESB.blank.getBaseEffect();
        float bestDiff = 5000.0f;
        for (int sideIndex = 0; sideIndex < sides.size(); ++sideIndex) {
            EntSide es = (EntSide)sides.get(sideIndex);
            Eff esBase = es.getBaseEffect();
            if (!SpellGeneration.okForAbilityMaybe(esBase)) continue;
            for (int v = 1; v < tier * 2 + 2; ++v) {
                EntSide es2 = es.withValue(v);
                float pw = es2.getEffectTier(HeroTypeUtils.defaultHero(tier));
                float diff = Math.abs(val - pw);
                if (diff / val < 0.04f) {
                    return es2.getBaseEffect();
                }
                if (!(diff < bestDiff)) continue;
                bestDiff = diff;
                best = es2.getBaseEffect();
            }
        }
        return best;
    }

    public static boolean okForAbilityMaybe(Eff esBase) {
        for (ConditionalRequirement restriction : esBase.getRestrictions()) {
            if (!restriction.toString().endsWith("Me")) continue;
            return false;
        }
        EffType type = esBase.getType();
        if (type == EffType.Mana || type == EffType.Recharge || type == EffType.RedirectIncoming || type == EffType.Blank) {
            return false;
        }
        if (esBase.getTargetingType() == TargetingType.Self) {
            return false;
        }
        for (Keyword w : esBase.getKeywords()) {
            if (SpellUtils.allowAddingKeyword(w)) continue;
            return false;
        }
        return true;
    }
}

