/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.effect.targetable.ability.tactic;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.gameplay.content.ent.Ent;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeUtils;
import com.tann.dice.gameplay.effect.eff.Eff;
import com.tann.dice.gameplay.effect.eff.EffBill;
import com.tann.dice.gameplay.effect.targetable.ability.Ability;
import com.tann.dice.gameplay.effect.targetable.ability.generation.TacticGeneration;
import com.tann.dice.gameplay.effect.targetable.ability.tactic.TacticCost;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.fightLog.Snapshot;
import com.tann.dice.gameplay.trigger.global.Global;
import com.tann.dice.statics.ImageUtils;
import com.tann.dice.util.Colours;
import com.tann.dice.util.ui.TextWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Tactic
extends Ability {
    final TacticCost tacticCost;

    public Tactic(String title, TacticCost tacticCost, EffBill eb) {
        this(title, tacticCost, eb.bEff());
    }

    public Tactic(String title, TacticCost tacticCost, Eff effect) {
        super(effect, title, Tactic.makeTacticImage(title));
        this.tacticCost = tacticCost;
    }

    private static TextureRegion makeTacticImage(String title) {
        return ImageUtils.loadExt("ability/tactic/special/placeholder");
    }

    @Override
    public Eff getBaseEffect() {
        return this.effect;
    }

    @Override
    public Eff getDerivedEffects() {
        return this.getBaseEffect();
    }

    @Override
    public Eff getDerivedEffects(List<Global> globals) {
        return this.getBaseEffect();
    }

    @Override
    public List<Actor> getCostActors(Snapshot presentSnapshot, int totalWidth) {
        List<Actor> acs = this.tacticCost.makeActors(presentSnapshot);
        if (acs.isEmpty()) {
            return Arrays.asList(new TextWriter("[green]free"));
        }
        return acs;
    }

    @Override
    public String describe() {
        return this.effect.describe(true) + "[grey] (" + this.describeCost() + ")";
    }

    public String describeCost() {
        return this.tacticCost.describe();
    }

    @Override
    public Color getIdCol() {
        return Colours.yellow;
    }

    @Override
    public boolean isUsable(Snapshot snapshot) {
        return this.tacticCost.isUsable(snapshot);
    }

    public List<Integer> getUsedHeroIndices(Snapshot snapshot) {
        List<EntState> useds = this.tacticCost.getHeroesWhoWantToBeUsedForTactic(snapshot);
        List<EntState> states = snapshot.getStates(true, false);
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (EntState used : useds) {
            indices.add(states.indexOf(used));
        }
        return indices;
    }

    @Override
    public Ent getSource() {
        return null;
    }

    @Override
    public boolean isPlayer() {
        return true;
    }

    @Override
    public void beforeUse(Snapshot snapshot, Eff preDerivedEffect, List<Integer> extraData) {
        List<EntState> states = snapshot.getStates(true, false);
        for (Integer extraDatum : extraData) {
            states.get(extraDatum).useDie();
        }
    }

    public int getNumCost() {
        return this.tacticCost.costs.size();
    }

    public TacticCost debugGetTacticCost() {
        return this.tacticCost;
    }

    @Override
    public boolean useImage() {
        return false;
    }

    @Override
    public float getCostFactorInActual(int heroTier) {
        return TacticGeneration.getPowerOfCostInOnePipSides(this.tacticCost, heroTier) * HeroTypeUtils.getEffectTierFor(heroTier);
    }
}

