/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.effect.targetable.ability.ui;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.tann.dice.gameplay.effect.targetable.ability.Ability;
import com.tann.dice.gameplay.effect.targetable.ability.spell.Spell;
import com.tann.dice.gameplay.effect.targetable.ability.tactic.Tactic;
import com.tann.dice.gameplay.effect.targetable.ability.ui.AbilityHolder;
import com.tann.dice.gameplay.fightLog.Snapshot;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.statics.Images;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Draw;
import com.tann.dice.util.ImageActor;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannFont;
import com.tann.dice.util.ui.Button;
import com.tann.dice.util.ui.TextWriter;
import java.util.List;

public class AbilityActor
extends Group {
    public static final int HEIGHT = 29;
    public static final int MAX_WIDTH = 48;
    static final int PIC_SIZE = 10;
    static final int BORDER_GAP = 0;
    static final int INNER_GAP = 2;
    static final int OUTER_GAP = 2;
    static final int TEXT_GAP = 0;
    static final int PIC_EXTRA_PIXELS = 0;
    final Ability ability;
    Snapshot presentSnapshot;
    boolean dead;
    boolean showText;

    public static boolean canDisplay(Ability ability, int width) {
        int textAvailable;
        int textWidth = TannFont.font.getWidth(ability.getTitle());
        return textWidth <= (textAvailable = width - 14);
    }

    public AbilityActor(Ability ability, int width, Snapshot present) {
        this.setTransform(false);
        this.setPresentSnapshot(present);
        this.ability = ability;
        this.reset(width);
        this.setTransform(false);
    }

    public void reset(int width) {
        this.clearChildren();
        this.setSize(width, 29.0f);
        ImageActor pic = new ImageActor(this.ability.getImage());
        String text = this.ability.getTitle();
        int textWidth = TannFont.font.getWidth(text);
        int textAvailable = (int)(this.getWidth() - 14.0f);
        Pixl p = new Pixl(0);
        if (this.ability instanceof Spell) {
            p.actor(pic);
            if (this.showText) {
                p.gap((textAvailable - textWidth) / 3);
                p.text(TextWriter.getTag(this.ability.getIdCol()) + text);
            }
        } else if (this.ability instanceof Tactic) {
            String tdt = text;
            if (!this.showText) {
                tdt = Tann.makeEllipses(tdt, 5);
            }
            p.text(TextWriter.getTag(this.ability.getIdCol()) + tdt);
        }
        Group g = p.pix();
        this.addActor(g);
        int TOP_PART_HEIGHT = 14;
        g.setPosition((int)(this.getWidth() / 2.0f - g.getWidth() / 2.0f), this.getHeight() - g.getHeight() / 2.0f - 7.0f);
        int outerGap = 2;
        int totalWidth = (int)(this.getWidth() - (float)(outerGap * 2));
        List<Actor> costActors = this.ability.getCostActors(this.presentSnapshot, totalWidth);
        int totalCostWidth = Tann.totalWidth(costActors);
        int totalGap = totalWidth - 4 - totalCostWidth;
        int perGap = Math.round(Math.min(5.0f, (float)totalGap / ((float)costActors.size() + 2.0f)));
        Pixl costPix = new Pixl(perGap);
        for (int i = 0; i < costActors.size(); ++i) {
            Actor a = costActors.get(i);
            costPix.actor(a);
        }
        Group ca = costPix.pix();
        this.addActor(ca);
        Tann.center(ca);
        int costSize = 16;
        ca.setY((int)(((float)costSize - ca.getHeight()) / 2.0f));
    }

    public void setPresentSnapshot(Snapshot presentSnapshot) {
        this.presentSnapshot = presentSnapshot;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        Group parent;
        batch.setColor(Colours.dark);
        Draw.fillRectangle(batch, this.getX() + 1.0f, this.getY() + 1.0f, this.getWidth() - 2.0f, this.getHeight() - 2.0f);
        boolean faded = this.isDead();
        if (!faded && (parent = this.getParent()) != null && parent instanceof AbilityHolder) {
            AbilityHolder sh = (AbilityHolder)parent;
            if (sh.tuckState == AbilityHolder.TuckState.Tucked) {
                faded = true;
            }
        }
        batch.setColor(this.ability.getCol());
        if (DungeonScreen.get() != null && DungeonScreen.get().targetingManager.getSelectedTargetable() == this.ability) {
            batch.setColor(Colours.light);
        }
        Button.ninePatch.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        Draw.fillRectangle(batch, this.getX(), this.getY() + this.getHeight() - 2.0f - 2.0f - 10.0f - 0.0f, this.getWidth(), 1.0f);
        super.draw(batch, parentAlpha);
        if (faded) {
            batch.setColor(Colours.withAlpha(Colours.dark, 0.45f));
            Button.ninePatch.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
            Draw.fillRectangle(batch, this.getX() + 1.0f, this.getY() + 1.0f, this.getWidth() - 2.0f, this.getHeight() - 2.0f);
        }
        if (this.isDead()) {
            batch.setColor(Colours.red);
            TextureRegion sk = Images.skull;
            batch.draw(sk, this.getX() + (float)((int)(this.getWidth() / 2.0f - (float)(sk.getRegionWidth() / 2))), this.getY() + (float)((int)(this.getHeight() / 2.0f - (float)(sk.getRegionHeight() / 2))));
        }
    }

    protected boolean isDead() {
        return this.dead;
    }

    public void setDead(Boolean b) {
        this.dead = b;
    }

    public void setShowText(boolean showText) {
        this.showText = showText;
    }
}

