/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.level;

import com.tann.dice.gameplay.content.ent.type.MonsterType;
import com.tann.dice.util.Tann;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

public class Symmetricality {
    public static void sort(final List<MonsterType> originalList) {
        HashSet<MonsterType> numTypes = new HashSet<MonsterType>(originalList);
        if (numTypes.size() == originalList.size()) {
            return;
        }
        ArrayList<MonsterType> sortedTypes = new ArrayList<MonsterType>(new HashSet<MonsterType>(originalList));
        Collections.sort(sortedTypes, new Comparator<MonsterType>(){

            @Override
            public int compare(MonsterType o1, MonsterType o2) {
                boolean even2;
                boolean even1 = Tann.countInList(o1, originalList) % 2 == 0;
                boolean bl = even2 = Tann.countInList(o2, originalList) % 2 == 0;
                if (even1 != even2) {
                    if (even1) {
                        return 1;
                    }
                    return -1;
                }
                int diff = Tann.countInList(o1, originalList) - Tann.countInList(o2, originalList);
                if (diff != 0) {
                    return diff;
                }
                return o2.size.getReinforceSize() - o1.size.getReinforceSize();
            }
        });
        ArrayList finalList = new ArrayList();
        for (MonsterType mt : sortedTypes) {
            int totalInList = Tann.countInList(mt, originalList);
            int leftHalf = (totalInList + (int)(Math.random() * 2.0)) / 2;
            int rightHalf = totalInList - leftHalf;
            Tann.addMultiple(finalList, mt, leftHalf, false);
            Tann.addMultiple(finalList, mt, rightHalf, true);
        }
        if (finalList.size() != originalList.size()) {
            throw new RuntimeException("Failed to sort list: " + originalList);
        }
        for (int i = 0; i < finalList.size(); ++i) {
            originalList.set(i, (MonsterType)finalList.get(i));
        }
    }
}

