/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.modifier;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.PipeMetaIndexed;
import com.tann.dice.gameplay.context.DungeonContext;
import com.tann.dice.gameplay.effect.eff.Eff;
import com.tann.dice.gameplay.effect.eff.keyword.Keyword;
import com.tann.dice.gameplay.fightLog.FightLog;
import com.tann.dice.gameplay.modifier.ModifierLib;
import com.tann.dice.gameplay.modifier.ModifierType;
import com.tann.dice.gameplay.modifier.ModifierUtils;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.Choosable;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.ChoosableType;
import com.tann.dice.gameplay.progress.chievo.unlock.Unlockable;
import com.tann.dice.gameplay.progress.stats.stat.Stat;
import com.tann.dice.gameplay.progress.stats.stat.pickRate.PickStat;
import com.tann.dice.gameplay.trigger.Collision;
import com.tann.dice.gameplay.trigger.Trigger;
import com.tann.dice.gameplay.trigger.global.Global;
import com.tann.dice.gameplay.trigger.global.chance.GlobalRarity;
import com.tann.dice.gameplay.trigger.global.chance.Rarity;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.screens.dungeon.panels.entPanel.choosablePanel.ModifierPanel;
import com.tann.dice.statics.Images;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.test.util.TestRunner;
import com.tann.dice.util.lang.Words;
import com.tann.dice.util.ui.TextWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class Modifier
implements Unlockable,
Choosable {
    protected final int tier;
    protected final float floatTier;
    protected final String name;
    protected final List<Global> globals;
    protected float chance;
    private final String essence;
    public static final float UNRATED_TIER = -0.069f;

    public Modifier(String name, Global ... globals) {
        this(-0.069f, name, Arrays.asList(globals));
    }

    public Modifier(float tier, String name, Global ... globals) {
        this(tier, name, Arrays.asList(globals));
    }

    public Modifier(float tier, String name, List<Global> globals) {
        this.tier = Math.round(tier);
        this.floatTier = tier;
        this.name = name;
        this.globals = new ArrayList<Global>(globals);
        this.essence = ModifierUtils.extractEssence(this);
        if (this.isComplexChain()) {
            this.rarity(Rarity.THIRD);
        }
        this.calculateChance();
    }

    private boolean isComplexChain() {
        return this.name.contains("^") && this.name.contains("/") && !this.name.contains(".") && !this.name.contains("&");
    }

    public List<Global> getGlobals() {
        return this.globals;
    }

    public Color getBorderColour() {
        return this.getMType().c;
    }

    public ModifierType getMType() {
        if (this.floatTier == -0.069f) {
            return ModifierType.Unrated;
        }
        if (this.tier > 0) {
            return ModifierType.Blessing;
        }
        if (this.tier < 0) {
            return ModifierType.Curse;
        }
        return ModifierType.Tweak;
    }

    public void playChooseSound() {
        switch (this.getMType()) {
            case Blessing: {
                Sounds.playSound(Sounds.magic);
                break;
            }
            case Curse: {
                Sounds.playSound(Sounds.deboost);
                break;
            }
            default: {
                Sounds.playSound(Sounds.bats);
            }
        }
    }

    public TextureRegion getLevelEndButtonIcon() {
        switch (this.getMType()) {
            case Blessing: {
                return Images.phaseBlessingIcon;
            }
            case Curse: {
                return Images.phaseCurseIcon;
            }
        }
        return Images.phaseTweakIcon;
    }

    @Override
    public String getName() {
        return this.getName(false);
    }

    public String getName(boolean display) {
        if (display) {
            return this.getDisplayName();
        }
        return this.name;
    }

    private String getDisplayName() {
        String name = this.getName(false);
        for (int i = 0; i < this.globals.size(); ++i) {
            name = this.globals.get(i).overrideDisplayName(name);
        }
        return name;
    }

    public ModifierPanel getPanel() {
        return new ModifierPanel(this, false);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public Actor makeUnlockActor(boolean big) {
        return new ModifierPanel(this, big);
    }

    @Override
    public String getAchievementIconString() {
        return TextWriter.getTag(this.getBorderColour()) + (this.getMType() == ModifierType.Curse ? "C" : "B");
    }

    @Override
    public TextureRegion getAchievementIcon() {
        return null;
    }

    @Override
    public void onChoose(DungeonContext dc, int index) {
        dc.addModifier(this);
    }

    @Override
    public void onReject(DungeonContext dc) {
        dc.getStatsManager().pickDelta(this, false);
    }

    public void onPickEffects(DungeonContext dc) {
        if (TestRunner.isTesting()) {
            return;
        }
        for (Global gt : this.getGlobals()) {
            gt.onPick(dc);
        }
        DungeonScreen ds = DungeonScreen.get();
        if (ds != null) {
            FightLog f = ds.getFightLog();
            f.updateOutOfCombat();
            f.refreshPresentBaseStats();
            ds.refreshTopButtonsPanel();
        }
    }

    @Override
    public Actor makeChoosableActor(boolean big, int index) {
        return new ModifierPanel(this, big);
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public float getModTier() {
        return this.getFloatTier();
    }

    @Override
    public final String describe() {
        return TextWriter.getTag(this.getBorderColour()) + ModifierUtils.describe(this.tier);
    }

    @Override
    public ChoosableType getType() {
        return ChoosableType.Modifier;
    }

    @Override
    public String getTierString() {
        if (this.getMType() == ModifierType.Unrated) {
            return "[orange]/[cu]";
        }
        return Words.getTierString(this.tier, true);
    }

    @Override
    public long getCollisionBits() {
        long bit = 0L;
        for (Trigger trigger : this.globals) {
            bit |= trigger.getCollisionBits();
        }
        if ((bit & Collision.GENERIC_ALL_SIDES_HERO) > 0L) {
            bit |= Collision.ALL_SIDES_HERO_COMPOSITE;
        }
        return bit;
    }

    @Override
    public float chance() {
        return this.chance;
    }

    public boolean skipTest() {
        for (Global gt : this.getGlobals()) {
            if (!gt.skipTest()) continue;
            return true;
        }
        return false;
    }

    public List<Keyword> getReferencedKeywords() {
        ArrayList<Keyword> keywords = new ArrayList<Keyword>();
        for (Global gt : this.globals) {
            keywords.addAll(gt.getReferencedKeywords());
        }
        return keywords;
    }

    public String getFullDescription() {
        try {
            return Trigger.describeTriggers(new ArrayList<Trigger>(this.globals));
        }
        catch (Exception e) {
            e.printStackTrace();
            if (TestRunner.isTesting()) {
                throw e;
            }
            return e.getClass().getSimpleName();
        }
    }

    @Override
    public boolean encountered(Map<String, Stat> allMergedStats) {
        return true;
    }

    @Override
    public int getPicks(Map<String, Stat> allMergedStats, boolean reject) {
        String tag = PickStat.nameFor(this);
        Stat s = allMergedStats.get(tag);
        if (s == null) {
            return 0;
        }
        return PickStat.val(s, reject);
    }

    @Override
    public String getSaveString() {
        String tiny;
        if (DungeonScreen.tinyPasting && (tiny = PipeMetaIndexed.tinyName(this)) != null && tiny.length() <= this.getName(false).length()) {
            return tiny;
        }
        return this.getName();
    }

    @Override
    public boolean isPositive() {
        return this.tier >= 0;
    }

    @Override
    public Color getColour() {
        return this.getBorderColour();
    }

    public Modifier rarity(Rarity rarity) {
        if (rarity == null || rarity == Rarity.ONE) {
            return this;
        }
        GlobalRarity existing = null;
        for (int i = 0; i < this.globals.size(); ++i) {
            Global g = this.globals.get(i);
            if (!(g instanceof GlobalRarity)) continue;
            existing = (GlobalRarity)g;
            break;
        }
        if (existing == null) {
            this.globals.add(GlobalRarity.fromRarity(rarity));
        } else {
            Rarity nr = Rarity.fromChance(rarity.getValue() * existing.chance());
            this.globals.set(this.globals.indexOf(existing), GlobalRarity.fromRarity(nr));
        }
        this.calculateChance();
        return this;
    }

    private void calculateChance() {
        this.chance = GlobalRarity.listChance(this.globals);
    }

    public boolean isMissingno() {
        return this == ModifierLib.getMissingno();
    }

    public Eff getSingleEffOrNull() {
        for (int i = 0; i < this.globals.size(); ++i) {
            Eff e = this.globals.get(i).getSingleEffOrNull();
            if (e == null) continue;
            return e;
        }
        return null;
    }

    public Global getSingleGlobalOrNull() {
        Global result = null;
        List<Global> globs = this.getGlobals();
        for (int i = 0; i < globs.size(); ++i) {
            Global g = globs.get(i);
            if (g.metaOnly()) continue;
            if (result != null) {
                return null;
            }
            result = g;
        }
        return result;
    }

    public float getFloatTier() {
        return this.floatTier == -0.069f ? 0.0f : this.floatTier;
    }

    public boolean hasFractionalTier() {
        return this.getFloatTier() != (float)this.getTier();
    }

    public boolean isOnPick() {
        for (int i = 0; i < this.globals.size(); ++i) {
            if (!this.globals.get(i).isOnPick()) continue;
            return true;
        }
        return false;
    }

    public boolean allTurnsOnly() {
        for (int i = 0; i < this.globals.size(); ++i) {
            if (!this.globals.get(i).allTurnsOnly()) continue;
            return true;
        }
        return false;
    }

    public boolean allLevelsOnly() {
        for (int i = 0; i < this.globals.size(); ++i) {
            if (!this.globals.get(i).allLevelsOnly()) continue;
            return true;
        }
        return false;
    }

    public boolean isMultiplable(boolean liberal) {
        return Trigger.checkMultiplability(this.globals, liberal);
    }

    public String getEssence() {
        return this.essence;
    }

    public boolean skipNotifyRandomReveal() {
        for (int i = 0; i < this.globals.size(); ++i) {
            if (!this.globals.get(i).skipNotifyRandomReveal()) continue;
            return true;
        }
        return false;
    }
}

