/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.modifier.generation;

import com.tann.dice.util.Tann;
import java.util.ArrayList;
import java.util.List;

public class CurseDistribution {
    public static final int FIRST = CurseDistribution.getBit(0);
    public static final int FOURTH = CurseDistribution.getBit(3);
    public static final int BOSSES = CurseDistribution.getBit(3) + CurseDistribution.getBit(7) + CurseDistribution.getBit(11) + CurseDistribution.getBit(15) + CurseDistribution.getBit(19);
    public static final int FIRST_TEN = 1023;
    public static final int SECOND_TEN = 1047552;
    public static final int LAST_TWO = 786432;
    public static final int FINAL_BOSS = CurseDistribution.getBit(19);
    public static final int ALL = 1048575;
    private static int[] ints = new int[]{FIRST, FOURTH, BOSSES, 1023, 1047552, 786432, FINAL_BOSS, 1048575};
    private static final int BIAS = 30;
    private static final int LEVELS = 20;
    private static final float FLAT = 0.0f;
    private static final float ACTIVE_FLAT = 0.5f;
    private static final float MAX_FLAT = 0.5f;
    private static final float ACTIVE_POW = 0.4f;

    private static int getBit(int level) {
        return 1 << level - 1;
    }

    public static List<String> getDebugData() {
        ArrayList<String> result = new ArrayList<String>();
        for (int anInt : ints) {
            List<Integer> activeLevels = CurseDistribution.getActiveLevels(anInt);
            String aStr = activeLevels + "";
            if (activeLevels.size() > 1) {
                boolean allInRow = true;
                for (int i = 1; i < activeLevels.size(); ++i) {
                    if (activeLevels.get(i) == activeLevels.get(i - 1) + 1) continue;
                    allInRow = false;
                }
                if (allInRow) {
                    aStr = activeLevels.get(0) + "-" + activeLevels.get(activeLevels.size() - 1);
                }
            }
            result.add(aStr + ": " + Tann.floatFormat(CurseDistribution.getMult(anInt)));
        }
        return result;
    }

    private static List<Integer> getActiveLevels(int input) {
        ArrayList<Integer> activeLevels = new ArrayList<Integer>();
        for (int i = 0; i < 30; ++i) {
            boolean active;
            boolean bl = active = (input & 1 << i) > 0;
            if (!active) continue;
            activeLevels.add(i + 1);
        }
        return activeLevels;
    }

    private static float getMultLevelAndAfter(int level) {
        int bit = 1048575 - (CurseDistribution.getBit(level) - 1);
        return CurseDistribution.getMult(bit);
    }

    public static float getMultLevelRange(int start, int end) {
        int bit = CurseDistribution.getBit(end + 1) - 1 - (CurseDistribution.getBit(start) - 1);
        return CurseDistribution.getMult(bit);
    }

    public static float getMultLevelAndAfter(int level, float perLevelValue) {
        return CurseDistribution.getMultLevelAndAfter(level) * perLevelValue;
    }

    public static float getMultLevelUntilEndEnd(int start, int end, int perLevelValue) {
        float result = 0.0f;
        for (int i = start; i <= end; ++i) {
            result += CurseDistribution.getMultUntilEnd(i);
        }
        return result * (float)perLevelValue;
    }

    private static float getMultUntilEnd(int i) {
        return CurseDistribution.getMultLevelRange(i, 20);
    }

    public static float getMult(int inputBits) {
        CurseDistribution.check(inputBits);
        int activeScore = 0;
        int maxScore = CurseDistribution.upTo(30) - CurseDistribution.upTo(10);
        int actives = 0;
        for (int i = 0; i < 20; ++i) {
            boolean active;
            boolean bl = active = (inputBits & 1 << i) > 0;
            if (!active) continue;
            activeScore += 30 - i;
            ++actives;
        }
        float activeRatio = (float)actives / 20.0f;
        float avgActiveWeighted = (float)activeScore / (float)maxScore;
        float fl = (float)(0.0 + 0.5 * Math.pow(activeRatio, 0.4f));
        return fl + 0.5f * avgActiveWeighted;
    }

    private static void check(int input) {
        for (int i = 20; i <= 31; ++i) {
            if ((input & 2 << i) <= 0) continue;
            throw new RuntimeException("bad set?");
        }
    }

    private static int upTo(int max) {
        return CurseDistribution.triangle(max);
    }

    private static int triangle(int i) {
        return (int)((float)i * ((float)i / 2.0f + 0.5f));
    }

    public static float getEachLevelAdd(int perLevelValue) {
        float result = 0.0f;
        for (int i = 0; i < 20; ++i) {
            result += CurseDistribution.getMult((1 << i) - 1) * (float)perLevelValue;
        }
        return result;
    }

    public static float getBossLevelsAdd(int perLevelValue) {
        float result = 0.0f;
        for (int i = 0; i < 5; ++i) {
            result += CurseDistribution.getMult((1 << i * 4) - 1) * (float)perLevelValue;
        }
        return result;
    }
}

