/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.challenge;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.content.item.ItemLib;
import com.tann.dice.gameplay.context.DungeonContext;
import com.tann.dice.gameplay.fightLog.FightLog;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.challenge.ChallengePhase;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.challenge.ChallengeType;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.Choosable;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.ChoosableUtils;
import com.tann.dice.util.Tann;
import java.util.ArrayList;
import java.util.List;

public class ChallengeReward {
    private String data;

    public ChallengeReward(List<Choosable> ch) {
        this.data = ChoosableUtils.serialiseList(ch);
    }

    public ChallengeReward() {
    }

    public static ChallengeReward generate(ChallengePhase.ChallengeDifficulty challengeDifficulty, DungeonContext dc, int currentLevelNumber, ChallengeType challengeType) {
        List<Item> items;
        int rewardLevel = Math.round(challengeType.getPower() * 0.33f);
        switch (challengeDifficulty) {
            case Easy: {
                items = ItemLib.randomWithExactQuality(rewardLevel, 1, dc);
                break;
            }
            default: {
                boolean multiple;
                boolean bl = multiple = Math.random() > 0.5;
                if (multiple) {
                    int quality = rewardLevel == 6 ? 3 : (rewardLevel >= 4 ? 2 : 1);
                    items = ItemLib.randomWithExactQuality(Math.round((float)rewardLevel / (float)quality), quality, dc);
                    break;
                }
                items = ItemLib.randomWithExactQuality(1, rewardLevel, dc);
            }
        }
        return new ChallengeReward(new ArrayList<Choosable>(items));
    }

    public List<Choosable> getRewards() {
        return ChoosableUtils.deserialiseList(this.data);
    }

    public Actor makeActor(boolean big) {
        List<Choosable> chz = this.getRewards();
        boolean small = chz.size() > 1 && !big;
        ArrayList<Actor> actors = new ArrayList<Actor>();
        for (Choosable e : chz) {
            Actor a = small ? e.makeChoosableActor(false, 0) : e.makeChoosableActor(big, 0);
            actors.add(a);
        }
        return Tann.layoutMinArea(actors, 2, (int)((float)Main.width * 0.6f), (int)((float)Main.height * 0.8f));
    }

    public void activate(FightLog fightLog) {
        DungeonContext dc = fightLog.getContext();
        ChoosableUtils.checkedOnChoose(this.getRewards(), dc, "trying to fight reward");
        fightLog.getContext().setCheckedItems(false);
    }

    public void reject(FightLog fightLog) {
        DungeonContext dc = fightLog.getContext();
        for (Choosable ch : this.getRewards()) {
            ch.onReject(dc);
        }
    }

    public int getNumRewards() {
        return this.getRewards().size();
    }
}

