/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.reveal;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.type.HeroType;
import com.tann.dice.gameplay.phase.Phase;
import com.tann.dice.gameplay.phase.PhaseManager;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.ChoicePhase;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.Choosable;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.ChoosableUtils;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.screens.dungeon.panels.Explanel.DiePanel;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import com.tann.dice.util.listener.TannListener;
import com.tann.dice.util.ui.standardButton.StandardButton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RandomRevealPhase
extends Phase {
    final List<Choosable> choosables;
    Actor g;

    public RandomRevealPhase(Choosable choosables) {
        this(Arrays.asList(choosables));
    }

    public RandomRevealPhase(List<? extends Choosable> choosables) {
        this.choosables = new ArrayList<Choosable>(choosables);
    }

    public RandomRevealPhase(String data) {
        this.choosables = ChoosableUtils.deserialiseList(data);
    }

    @Override
    public void activate() {
        this.g = RandomRevealPhase.makeWholeRevealGroup("[yellow]Gained:", this.choosables, new Runnable(){

            @Override
            public void run() {
                RandomRevealPhase.this.onOk();
            }
        });
        Sounds.playSound(Sounds.chooseItem);
        DungeonScreen.get().addActor(this.g);
        Tann.center(this.g);
        this.g.setY(ChoicePhase.getShowY(this.g));
    }

    public void onOk() {
        Sounds.playSound(Sounds.pop);
        this.g.remove();
        PhaseManager.get().popPhase(this.getClass());
        DungeonScreen.get().save();
    }

    private static List<Actor> makeActors(List<Choosable> choosables, boolean big) {
        ArrayList<Actor> actors = new ArrayList<Actor>();
        for (Choosable c : choosables) {
            Actor a = c instanceof HeroType ? new DiePanel(((HeroType)c).makeEnt()) : c.makeChoosableActor(big, 0);
            actors.add(a);
        }
        return actors;
    }

    public static Actor makeWholeRevealGroup(String title, List<Choosable> choosables, final Runnable okActor) {
        Pixl p = new Pixl(3, 3).border(Colours.grey).text(title).row();
        p.actor(RandomRevealPhase.makeGroupNiceSize(choosables));
        StandardButton ok = new StandardButton("[green][b]ok", Colours.green);
        ok.addListener(new TannListener(){

            @Override
            public boolean action(int button, int pointer, float x, float y) {
                okActor.run();
                return true;
            }
        });
        p.row().actor(ok);
        return p.pix();
    }

    public static Actor makeGroupNiceSize(List<Choosable> choosables) {
        int maxWidth = (int)((float)Main.width * 0.8f);
        int maxHeight = (int)((float)Main.height * 0.6f);
        Group a = Tann.layoutMinArea(RandomRevealPhase.makeActors(choosables, true), 3, maxWidth, maxHeight);
        if (a.getWidth() < (float)maxWidth && a.getHeight() < (float)maxHeight) {
            return a;
        }
        return Tann.layoutMinArea(RandomRevealPhase.makeActors(choosables, false), 3, maxWidth, maxHeight);
    }

    @Override
    public void deactivate() {
        this.g.remove();
    }

    @Override
    public boolean canSave() {
        return true;
    }

    @Override
    protected StandardButton getLevelEndButtonInternal() {
        return new StandardButton("??");
    }

    @Override
    public String serialise() {
        return "r" + ChoosableUtils.serialiseList(this.choosables);
    }

    @Override
    public boolean keyPress(int keycode) {
        switch (keycode) {
            case 111: {
                return false;
            }
            case 62: 
            case 66: 
            case 160: {
                this.onOk();
                return true;
            }
        }
        return false;
    }
}

