/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.save.settings.option;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.utils.ObjectMap;
import com.tann.dice.Main;
import com.tann.dice.gameplay.effect.targetable.ability.ui.AbilityHolder;
import com.tann.dice.gameplay.save.settings.option.BOption;
import com.tann.dice.gameplay.save.settings.option.ChOption;
import com.tann.dice.gameplay.save.settings.option.FlOption;
import com.tann.dice.gameplay.save.settings.option.Option;
import com.tann.dice.platform.control.desktop.DesktopControl;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.screens.dungeon.DungeonUtils;
import com.tann.dice.screens.dungeon.panels.book.page.stuffPage.APIUtils;
import com.tann.dice.screens.titleScreen.TitleScreen;
import com.tann.dice.statics.Images;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.statics.sound.music.JukeboxUtils;
import com.tann.dice.statics.sound.music.MusicManager;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannFont;
import com.tann.dice.util.TannLog;
import com.tann.dice.util.lang.Words;
import com.tann.dice.util.listener.TannListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class OptionLib {
    private static final float CHANCE_LOW = 0.05f;
    private static final float CHANCE_HIGH = 0.2f;
    private static final String PERC_LOW = "5%";
    private static final String PERC_HIGH = "20%";
    public static final BOption FAST_ENEMY_TURNS = new BOption("fast enemy turns", "3x speed for enemy rolling and combat animations");
    public static final BOption COMPLEX_HARD_EASY = new BOption("complex [orange]hard[p][yellow]/[p][green]easy", "All easy/hard difficulties use a point-buy system similar to unfair+");
    public static final BOption MYRIAD_OFFERS = new BOption("myriad offers", "For difficulty modifier offers: [green]+100% options[cu] but [purple]+15% required value");
    public static final BOption PRE_RANDOMISE = new BOption("0.16667", "Ensure precisely 1/6 chance for each side to land [grey]by rotating to a random side before rolling");
    public static final BOption GENERATED_HEROES = new BOption("5% generated [yellow]heroes[cu]", "Each starting hero and levelup option has a chance to be replaced with a random generated hero");
    public static final BOption GENERATED_ITEMS = new BOption("5% generated [grey]items", "Item rewards have a chance to be replaced with a badly-balanced generated item");
    public static final BOption GENERATED_MONSTERS = new BOption("5% generated [orange]monsters", "Try it, you'll see them");
    public static final BOption WILD_MODIFIERS = new BOption("5% wild [purple]modifiers", "They appear in difficulty offers etc");
    public static final BOption INCREASE_PERCENTAGE = new BOption("5% -> 20%", "all '5%' options are now more likely");
    public static final BOption BYPASS_UNLOCKS = new BOption("bypass unlocks", "Unlock everything, though you can still earn achievements as normal"){

        @Override
        protected String warnString() {
            String mvs;
            boolean moveScreen = !(Main.getCurrentScreen() instanceof TitleScreen);
            String string = mvs = moveScreen ? "You will be returned to the title screen" : null;
            if (this.c()) {
                if (moveScreen) {
                    return mvs;
                }
                return null;
            }
            return "Locked things are [purple]more complex, [orange]not more powerful.[cu][n][nh][grey](this doesn't affect achievements and you can undo it" + (mvs == null ? "" : ", also " + mvs.toLowerCase()) + ")";
        }

        @Override
        protected void manualSelectAction() {
            Main.unlockManager().resetUnlocks();
            Main.self().setScreen(new TitleScreen());
            String s = this.c() ? "[text][yellow]100% unlocked[cu][n][nh]The game will be a lot more [purple]complex[cu] now[n][nh]Remember you can undo this if it's too much!" : "Unlocks synced with [yellow]" + Words.plural("achievement");
            Main.getCurrentScreen().showDialog(s);
            Sounds.playSound(this.c() ? Sounds.deathBig : Sounds.magic);
        }
    };
    public static final BOption DISABLE_CHAT = new BOption("disable chat", "Disable all speech bubbles from heroes");
    public static final BOption AUTO_FLEE = new BOption("auto-flee", "Monsters will always be allowed to flee if they want");
    public static final BOption SHOW_COPY = new BOption("copy button", Main.self().control.getSelectTapString() + " on the faint triangle bottom left of a hero, monster, modifier, item to copy to clipboard."){

        @Override
        protected void manualSelectAction() {
            APIUtils.refreshCopyButton();
        }
    };
    public static final BOption SHOW_TIMER = new BOption("show timer", "Timer for speedrunning, time is calculated from the date you started the run"){

        @Override
        protected void manualSelectAction() {
            DungeonScreen ds = DungeonScreen.getCurrentScreenIfDungeon(false);
            if (ds != null) {
                ds.refreshTimer();
            }
        }
    };
    public static final BOption SHOW_CLOCK = new BOption("show clock", "A few people saying the game made them late for work"){

        @Override
        protected void manualSelectAction() {
            DungeonScreen ds = DungeonScreen.getCurrentScreenIfDungeon(false);
            if (ds != null) {
                ds.refreshClock();
            }
        }
    };
    public static final BOption SHOW_RARITY = new BOption("show rarity", "Many things in the game have rarity. It's not intended to be an exciting thing, just to balance out distributions and stop annoying/weird things from showing up too much"){

        @Override
        protected void manualSelectAction() {
            OptionLib.mayRequireRestart();
        }
    };
    public static final BOption FRACTIONAL_TIER = new BOption("fractional tier", "Sometimes calculations are used to create modifier tiers and it's useful to store them with more precision"){

        @Override
        protected void manualSelectAction() {
            OptionLib.mayRequireRestart();
        }
    };
    public static final BOption ROMAN_MODE = new BOption("roman numerals", "alea iacta est"){

        @Override
        protected void manualSelectAction() {
            OptionLib.mayRequireRestart();
        }
    };
    public static final BOption TINY_PASTE = new BOption("tiny paste", "makes pastes smaller");
    public static final BOption LEVELUP_HORUS_ONLY = new BOption("horus levelup", "For unknown heroes, levelup will try to equip them with an item. This falls back to +4hp and +1 to all sides which is a bit more sane.");
    public static final BOption GENERATE_50 = new BOption("api2 20", "Try to make 20 of each thing on api-2, instead of 6");
    public static final BOption CUSTOM_REARRANGE = new BOption("custom rearrange", "rearrange modifiers in custom mode"){

        @Override
        protected void manualSelectAction() {
            OptionLib.mayRequireRestart(false);
        }
    };
    public static final BOption LONGTAP_END = new BOption("longtap end", "tap+hold or right-click on reroll button to 'confirm'. I added this to help me play one-handed on a phone.");
    public static final BOption CRAZY_UI = new BOption("crazy UI", "panels burn away etc"){

        @Override
        protected void manualSelectAction() {
            if (++crazyTaps >= 15) {
                Sounds.playSound(Sounds.pipSmall);
                TannFont.GLOBAL_GLITCH = CRAZY_UI.c();
            }
        }
    };
    public static final BOption DISABLE_MARQUEE = new BOption("disable <marquee>", "show ... instead of scrolling text"){

        @Override
        protected void manualSelectAction() {
            OptionLib.mayRequireRestart();
        }
    };
    public static int crazyTaps = 0;
    public static final BOption ALWAYS_SHOW_TARG_BUTTON = new BOption("target button", "always show the red targeting button at the top to show monster targeting"){

        @Override
        protected void manualSelectAction() {
            OptionLib.mayRequireRestart();
        }
    };
    public static final BOption TRIPLE_CHAT = new BOption("triple chat", "hero chats happen more frequently");
    public static final BOption TEXTMOD_HIDDEN = new BOption("textmod [purple]+more", "Show more textmod apis, the new ones are purple");
    public static final BOption HIDE_SPINNERS = new BOption("hide spinning dice", "Hides UI spinny dice. This could render weirdly on certain machines, or cause lag.");
    public static final BOption DISABLE_2D_3D_IMAGE = new BOption("disable optimisation 1", "An optimisation I made to reduce texture swaps, though I'm concerned it could cause visual glitches on Android maybe. It's easy to toggle at runtime so you can see if it did anything too!");
    public static final BOption DISABLE_3D_DISPOSE = new BOption("disable dispose", "stop disposing 3d assets, maybe this causes a crash on android?");
    public static final BOption DISABLE_PREDICT = new BOption("disable predict", "stop roll-predict saving, maybe this causes a crash on android");
    public static final BOption DISABLE_RUNTIME_TEXTURES = new BOption("disable +textures", "Some of the weird stuff in this game involves creating textures at runtime (like decals). This might cause issues on some devices so tick this to just use the original textures instead.");
    public static final BOption SMARTPHONE_CONTROLS = new BOption("smartphone controls", "Use long tap for right-click on desktop, maybe useful for steamdeck"){

        @Override
        protected void manualSelectAction() {
            OptionLib.mayRequireRestart(false);
        }

        @Override
        public boolean isValid() {
            return Main.self().control instanceof DesktopControl;
        }
    };
    public static final ChOption MUSIC_LOAD_TYPE = new ChOption("music load", "load music differently, maybe this was causing an issue - preload requires app restart", "thread", "preload", "lazy");
    public static final BOption HASH_ICONS = new BOption("icons", "show full iconography in # section where possible");
    public static final BOption REMOVE_SAVE_BUTT = new BOption("remove this!", "removes the joke save button"){

        @Override
        protected void manualSelectAction() {
            OptionLib.mayRequireRestart(false);
        }
    };
    public static final ChOption GAP = new ChOption("gap", "Make a gap for something like a stream avatar or video. Not available in portrait.", new String[]{"none", "bot", "top"}){

        @Override
        protected void manualSelectAction() {
            OptionLib.mayRequireRestart();
        }

        @Override
        public boolean isValid() {
            return !Main.isPortrait();
        }
    };
    public static final ChOption BUTT_STYLE = new ChOption("Button Style", null, new String[]{"Rounded", "Sides", "Corners", "SimpleSquare"}){

        @Override
        protected void manualSelectAction() {
            OptionLib.mayRequireRestart(false);
        }
    };
    public static final BOption SHOW_PLAYING_POPUP = new BOption("music popups", "show the name of the track when it is played");
    public static final ChOption AFFECT_LOOP = new ChOption("music loop", "some tracks loop one or twice, this affects that[n][grey][tick]- normal loops[n]X- no loops[n]\u221e- loop 999 times", new String[]{"[tick]", "X", "\u221e"}){

        @Override
        protected void manualSelectAction() {
            MusicManager.userRequestNextSong();
        }
    };
    public static final ChOption MUSIC_SELECTION = new ChOption("music selection", "[yellow]DJ:[cu] plays music that fits where you are[n][yellow]Shuffle:[cu] picks from all enabled tracks", new String[]{"DJ", "Shuffle"}){

        @Override
        protected void manualSelectAction() {
            MusicManager.checkSongIsValid(true);
        }
    };
    public static final BOption SHOW_STAT_POPUPS = new BOption("show stat updates");
    public static final BOption SHOW_LEVEL_DIFF = new BOption("level val");
    public static final BOption SHOW_RENDERCALLS = new BOption("show renders");
    public static final BOption MOD_CALC = new BOption("show modcalc");
    public static final BOption SHOW_GRB = new BOption("show grb");
    public static final BOption SHOW_PREDICTION = new BOption("show prediction");
    public static final BOption DISABLE_API_ORDER = new BOption("disable API sort");
    public static final FlOption sfx = new FlOption("sfx"){

        @Override
        protected void manualSelectAction() {
            if (Main.frames % 15 == 0) {
                Sounds.playSound(Sounds.pip);
            }
        }
    };
    public static final FlOption music = new FlOption("music"){

        @Override
        public float getDefaultValue() {
            return 0.15f;
        }

        @Override
        protected void manualSelectAction() {
        }
    };
    private static List<Option> list;

    public static Actor makeLockButton() {
        Actor lockButton = DungeonUtils.makeBasicButton(Images.unlocked);
        lockButton.addListener(new TannListener(){

            @Override
            public boolean action(int button, int pointer, float x, float y) {
                Pixl p = new Pixl(3, 4).border(Colours.purple);
                p.text("Unlocks are currently [purple]bypassed[cu][n]Would you like to re-enable?");
                p.row();
                p.actor(BYPASS_UNLOCKS.makeUnlockActor(true));
                Group a = p.pix();
                Sounds.playSound(Sounds.pip);
                Main.getCurrentScreen().push(a);
                Tann.center(a);
                return true;
            }
        });
        return lockButton;
    }

    public static float genChance() {
        return INCREASE_PERCENTAGE.c() ? 0.2f : 0.05f;
    }

    public static boolean shouldShowCopy() {
        return SHOW_COPY.c();
    }

    public static int affectLoops(int baseLoops) {
        switch (AFFECT_LOOP.c()) {
            default: {
                return baseLoops;
            }
            case 1: {
                return 1;
            }
            case 2: 
        }
        return 999;
    }

    private static void mayRequireRestart() {
        OptionLib.mayRequireRestart(true);
    }

    private static void mayRequireRestart(boolean inGameOnly) {
        DungeonScreen ds;
        if (inGameOnly && (ds = DungeonScreen.getCurrentScreenIfDungeon(false)) == null) {
            return;
        }
        AbilityHolder.showInfo("may require quit/load", Colours.purple);
    }

    public static void loadValuesFrom(List<String> enabledBooleans, ObjectMap<String, Integer> chopValues, ObjectMap<String, Float> flopValues) {
        Option chop;
        for (Option option : list) {
            option.reset();
        }
        for (String string : enabledBooleans) {
            Option bo = OptionLib.byName(string);
            if (!(bo instanceof BOption)) {
                TannLog.log("Error finding booleanoption with name " + string, TannLog.Severity.error);
                continue;
            }
            ((BOption)bo).setValue(true, false);
        }
        for (ObjectMap.Entry entry : chopValues) {
            chop = OptionLib.byName((String)entry.key);
            if (!(chop instanceof ChOption)) {
                TannLog.log("Error finding ChOption with name " + (String)entry.key, TannLog.Severity.error);
                continue;
            }
            ((ChOption)chop).setValue((Integer)entry.value, false);
        }
        for (ObjectMap.Entry entry : flopValues) {
            chop = OptionLib.byName((String)entry.key);
            if (!(chop instanceof FlOption)) {
                TannLog.log("Error finding ChOption with name " + (String)entry.key, TannLog.Severity.error);
                continue;
            }
            ((FlOption)chop).setValue(((Float)entry.value).floatValue(), false);
        }
    }

    private static Option byName(String name) {
        for (Option bo : list) {
            if (!bo.name.equals(name)) continue;
            return bo;
        }
        return null;
    }

    public static List<Option> getAll() {
        return list;
    }

    public static void init() {
        list = new ArrayList<Option>();
        for (EscBopType value : EscBopType.values()) {
            list.addAll(value.getOptions());
        }
    }

    public static enum EscBopType {
        Top(false),
        Misc(false),
        Gameplay(true),
        UI(true),
        Modding(true),
        Music(false),
        Compatibility(true),
        Debug(false);

        public final boolean shownInOptions;

        private EscBopType(boolean shownInOptions) {
            this.shownInOptions = shownInOptions;
        }

        public List<Option> getOptions() {
            switch (this) {
                case Top: {
                    return Arrays.asList(sfx, music);
                }
                case Gameplay: {
                    return Arrays.asList(BYPASS_UNLOCKS, GENERATED_HEROES, GENERATED_ITEMS, GENERATED_MONSTERS, WILD_MODIFIERS, INCREASE_PERCENTAGE, COMPLEX_HARD_EASY, MYRIAD_OFFERS, PRE_RANDOMISE);
                }
                case Modding: {
                    return Arrays.asList(SHOW_COPY, TEXTMOD_HIDDEN, CUSTOM_REARRANGE, DISABLE_MARQUEE, TINY_PASTE, LEVELUP_HORUS_ONLY, GENERATE_50);
                }
                case UI: {
                    ArrayList<Option> options = new ArrayList<Option>(Arrays.asList(FAST_ENEMY_TURNS, AUTO_FLEE, SHOW_TIMER, SHOW_CLOCK, SHOW_RARITY, ALWAYS_SHOW_TARG_BUTTON, TRIPLE_CHAT, ROMAN_MODE, CRAZY_UI, LONGTAP_END, GAP));
                    if (Gdx.app.getType() == Application.ApplicationType.iOS) {
                        options.remove(GAP);
                    }
                    return options;
                }
                case Compatibility: {
                    return Arrays.asList(HIDE_SPINNERS, DISABLE_2D_3D_IMAGE, DISABLE_3D_DISPOSE, DISABLE_RUNTIME_TEXTURES, SMARTPHONE_CONTROLS);
                }
                case Misc: {
                    return Arrays.asList(HASH_ICONS, REMOVE_SAVE_BUTT);
                }
                case Debug: {
                    return Arrays.asList(SHOW_STAT_POPUPS, SHOW_LEVEL_DIFF, SHOW_RENDERCALLS, MOD_CALC, SHOW_GRB, SHOW_PREDICTION, DISABLE_API_ORDER, FRACTIONAL_TIER, BUTT_STYLE, DISABLE_CHAT, DISABLE_PREDICT);
                }
                case Music: {
                    return Arrays.asList(SHOW_PLAYING_POPUP, AFFECT_LOOP, MUSIC_SELECTION, MUSIC_LOAD_TYPE);
                }
            }
            return Arrays.asList(new Option[0]);
        }

        public Color getCol() {
            switch (this) {
                case Compatibility: {
                    return Colours.grey;
                }
                case UI: {
                    return Colours.text;
                }
                case Gameplay: {
                    return Colours.orange;
                }
                case Music: {
                    return JukeboxUtils.SOUND_COL;
                }
                case Modding: {
                    return Colours.red;
                }
            }
            return Colours.pink;
        }
    }
}

