/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.trigger.global.chance;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.gameplay.save.settings.option.OptionLib;
import com.tann.dice.gameplay.trigger.global.Global;
import com.tann.dice.gameplay.trigger.global.chance.Rarity;
import com.tann.dice.statics.Images;
import com.tann.dice.util.ImageActor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GlobalRarity
extends Global {
    final Rarity rarity;
    private static final Map<Rarity, GlobalRarity> map = GlobalRarity.init();

    private GlobalRarity(Rarity rarity) {
        this.rarity = rarity;
    }

    public static float listChance(List<Global> globals) {
        float chance = 1.0f;
        for (int i = 0; i < globals.size(); ++i) {
            chance *= globals.get(i).chance();
        }
        return chance;
    }

    @Override
    public float chance() {
        return this.rarity.value;
    }

    @Override
    public String describeForSelfBuff() {
        if (OptionLib.SHOW_RARITY.c()) {
            return "[text]Rarity: [cu]" + this.rarity.toColourTaggedString();
        }
        return null;
    }

    @Override
    public Actor makePanelActorI(boolean big) {
        return new ImageActor(Images.rarity_star, this.rarity.col);
    }

    @Override
    public boolean skipEquipImage() {
        return !OptionLib.SHOW_RARITY.c();
    }

    @Override
    public boolean metaOnly() {
        return true;
    }

    private static Map<Rarity, GlobalRarity> init() {
        HashMap<Rarity, GlobalRarity> result = new HashMap<Rarity, GlobalRarity>();
        for (Rarity r : Rarity.values()) {
            result.put(r, new GlobalRarity(r));
        }
        return result;
    }

    public static GlobalRarity fromRarity(Rarity r) {
        return map.get((Object)r);
    }
}

