/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.trigger.global.eff;

import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.type.MonsterType;
import com.tann.dice.gameplay.content.gen.pipe.mod.PipeModAddMonsterMeta;
import com.tann.dice.gameplay.effect.eff.Eff;
import com.tann.dice.gameplay.effect.eff.EffBill;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.gameplay.trigger.global.Global;
import com.tann.dice.gameplay.trigger.global.eff.GlobalStartTurnEff;
import com.tann.dice.gameplay.trigger.global.linked.DipPanel;
import com.tann.dice.gameplay.trigger.global.scaffolding.turnRequirement.GlobalTurnRequirement;
import com.tann.dice.gameplay.trigger.global.scaffolding.turnRequirement.TurnRequirement;
import com.tann.dice.gameplay.trigger.global.scaffolding.turnRequirement.TurnRequirementAll;
import com.tann.dice.gameplay.trigger.global.scaffolding.turnRequirement.TurnRequirementEveryN;
import com.tann.dice.screens.dungeon.panels.Explanel.DiePanel;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import com.tann.dice.util.lang.Words;

public class GlobalSummonMonsterStartTurn
extends GlobalTurnRequirement {
    final MonsterType type;

    public GlobalSummonMonsterStartTurn(TurnRequirement turnRequirement, MonsterType type) {
        super(turnRequirement, (Global)new GlobalStartTurnEff(new Eff[]{new EffBill().summon(type.getName(false), 1).bEff()}));
        this.type = type;
    }

    @Override
    public String describeForSelfBuff() {
        return this.describeSummon() + " " + this.requirement.describe().toLowerCase();
    }

    private String describeSummon() {
        return "Summon " + Words.fullPlural(this.type.getName(true).toLowerCase(), 1);
    }

    @Override
    public Actor makePanelActorI(boolean big) {
        if (big) {
            Pixl p = new Pixl(0);
            p.actor(new DiePanel(this.type.makeEnt()).withoutDice().getFullActor(), Main.width / 2);
            return p.pix();
        }
        return DipPanel.makeSidePanelGroup(this.requirement.makePanelActor(), new Pixl().text("[pink][plus]").gap(2).image((TextureRegion)this.type.portrait, true).pix(), GlobalTurnRequirement.TURN_COL);
    }

    public static Modifier makeGenerated(MonsterType mt, boolean eachTurn) {
        if (mt.getName().equalsIgnoreCase("chest")) {
            return null;
        }
        if (mt.isUnique()) {
            return null;
        }
        TurnRequirement rq = eachTurn ? new TurnRequirementAll() : new TurnRequirementEveryN(3);
        int maxTier = eachTurn ? 60 : 9;
        float aprroxStr = mt.getSummonValue();
        float tier = aprroxStr * (eachTurn ? 2.2f : 0.54f);
        String pref = (eachTurn ? "Summon" : "3rd") + ".";
        String name = pref + (PipeModAddMonsterMeta.ALLOW_PLURAL_NAME ? Words.plural(mt.getName(false)) : mt.getName(false));
        if (!eachTurn) {
            float softMax = (float)maxTier * 0.8f;
            tier = Tann.softLimit(tier, softMax, maxTier);
        }
        return new Modifier(-tier, name, new GlobalSummonMonsterStartTurn(rq, mt));
    }

    @Override
    public boolean isMultiplable() {
        return true;
    }
}

