/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.trigger.global.linked;

import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.tann.dice.gameplay.content.ent.type.MonsterType;
import com.tann.dice.gameplay.effect.eff.EffBill;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.fightLog.event.snapshot.SoundSnapshotEvent;
import com.tann.dice.gameplay.trigger.global.linked.DipPanel;
import com.tann.dice.gameplay.trigger.global.linked.GlobalLinked;
import com.tann.dice.gameplay.trigger.personal.Personal;
import com.tann.dice.gameplay.trigger.personal.death.OnDeathEffect;
import com.tann.dice.statics.Images;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.ImageActor;
import com.tann.dice.util.Tann;
import com.tann.dice.util.lang.Words;

public class GlobalAllMonstersExcept
extends GlobalLinked {
    public final Personal trigger;
    final MonsterType except;

    public GlobalAllMonstersExcept(MonsterType except, Personal trigger) {
        super(trigger);
        this.except = except;
        this.trigger = trigger;
    }

    @Override
    public String describeForSelfBuff() {
        String start = "";
        start = "[red]All monsters except " + this.except.getName(true).toLowerCase() + ":[cu][n]";
        return start + Words.capitaliseFirst(this.trigger.describeForSelfBuff().toLowerCase());
    }

    @Override
    public Personal getLinkedTrigger(EntState entState) {
        if (!entState.getEnt().isPlayer() && entState.getEnt().entType != this.except) {
            return this.trigger;
        }
        return super.getLinkedTrigger(entState);
    }

    @Override
    public Actor makePanelActorI(boolean big) {
        Group exception = Tann.combineActors(new ImageActor((TextureRegion)this.except.portrait, true), new ImageActor(Images.ui_cross, Colours.red));
        return DipPanel.makeSidePanelGroup(big, (Actor)exception, this.trigger, Colours.red);
    }

    public static GlobalAllMonstersExcept summonOnDeath(MonsterType mt) {
        return new GlobalAllMonstersExcept(mt, new OnDeathEffect(new EffBill().summon(mt.getName(false), 1).bEff(), new SoundSnapshotEvent(Sounds.summonBones)));
    }
}

