/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.trigger.global.pool.hero;

import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.gameplay.content.ent.type.HeroType;
import com.tann.dice.gameplay.trigger.global.Global;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import java.util.ArrayList;
import java.util.List;

public class GlobalExtraLevelupOptions
extends Global {
    private final List<HeroType> extras;

    public GlobalExtraLevelupOptions(List<HeroType> extras) {
        this.extras = extras;
    }

    @Override
    public List<HeroType> getExtraLevelupOptions(HeroType ht, int newTier) {
        ArrayList<HeroType> result = new ArrayList<HeroType>();
        for (HeroType option : this.extras) {
            if (option.heroCol != ht.heroCol || option.level != newTier) continue;
            result.add(option);
        }
        return result;
    }

    @Override
    public Actor makePanelActorI(boolean big) {
        Pixl p = new Pixl(3, 3).border(Colours.yellow);
        p.text("Hero Pool +").row();
        if (this.extras.size() > 20) {
            big = false;
        }
        if (big) {
            for (HeroType option : this.extras) {
                p.image((TextureRegion)option.portrait, 100);
            }
        } else {
            p.text(this.extras.size());
        }
        return p.pix();
    }

    @Override
    public String describeForSelfBuff() {
        ArrayList<String> strings = new ArrayList<String>();
        for (HeroType option : this.extras) {
            strings.add(option.getName());
        }
        return "Add " + Tann.commaList(strings) + " to the hero pool";
    }
}

