/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.trigger.personal.immunity;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.tann.dice.Main;
import com.tann.dice.gameplay.effect.eff.Eff;
import com.tann.dice.gameplay.effect.eff.TargetingType;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.trigger.Collision;
import com.tann.dice.gameplay.trigger.personal.immunity.Immunity;
import com.tann.dice.screens.dungeon.panels.entPanel.EntPanel;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Draw;
import com.tann.dice.util.lang.Words;

public class DamageImmunity
extends Immunity {
    final boolean poison;
    final boolean regular;
    final boolean show;

    public DamageImmunity(boolean poison, boolean regular) {
        this(poison, regular, true);
    }

    public DamageImmunity(boolean poison, boolean regular, boolean show) {
        this.poison = poison;
        this.regular = regular;
        this.show = show;
    }

    @Override
    public boolean immuneToDamage(boolean poison) {
        if (poison) {
            return this.poison;
        }
        return this.regular;
    }

    @Override
    public boolean poisonSpecificImmunity() {
        return this.poison && !this.regular;
    }

    @Override
    public String getImageName() {
        if (!this.regular) {
            return "poisonImmunity";
        }
        if (this.poison && this.regular) {
            return "immune";
        }
        return super.getImageName();
    }

    @Override
    public boolean showInEntPanelInternal() {
        return this.show;
    }

    @Override
    public String describeForGiveBuff(Eff source) {
        if (source.getTargetingType() == TargetingType.Group) {
            return "All allies become " + this.describeForSelfBuff();
        }
        return "Target " + Words.entName(source, null) + " becomes " + this.describeForSelfBuff().toLowerCase();
    }

    @Override
    public String describeForSelfBuff() {
        if (this.poison && this.regular) {
            return "Immune to damage";
        }
        if (this.poison && !this.regular) {
            return "Immune to poison";
        }
        if (this.regular && !this.poison) {
            return "Immune to non-poison damage";
        }
        return "Damage immunity gone wrong!";
    }

    @Override
    public boolean isRecommended(EntState sourceState, EntState targetPresent, EntState targetFuture) {
        return this.regular && targetFuture.getBlockableDamageTaken() + targetFuture.getDamageBlocked() > targetPresent.getBlockableDamageTaken() + targetPresent.getDamageBlocked() || this.poison && targetFuture.getPoisonDamageTaken(true) > targetPresent.getPoisonDamageTaken(true);
    }

    @Override
    public void drawOnPanel(Batch batch, EntPanel entPanel) {
        if (!this.regular || !this.show) {
            return;
        }
        float alpha = Main.pulsateFactor() * 0.06f + 0.3f;
        batch.setColor(Colours.withAlpha(Colours.grey, alpha));
        Draw.fillActor(batch, entPanel);
    }

    @Override
    public String[] getSound() {
        return Sounds.stealth;
    }

    @Override
    public float getPriority() {
        return 10.0f;
    }

    @Override
    public float getEffectTier(int pips, int tier) {
        return 0.2f + (float)tier * 0.8f;
    }

    @Override
    public long getCollisionBits(Boolean player) {
        if (this.poison) {
            return Collision.POISON;
        }
        return super.getCollisionBits(player);
    }
}

