/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.trigger.personal.linked.perN;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.fightLog.Snapshot;
import com.tann.dice.gameplay.trigger.global.linked.DipPanel;
import com.tann.dice.gameplay.trigger.personal.Personal;
import com.tann.dice.gameplay.trigger.personal.linked.LinkedPersonal;
import com.tann.dice.gameplay.trigger.personal.linked.perN.ns.PerN;
import com.tann.dice.gameplay.trigger.personal.linked.perN.ns.PerNFlat;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PersonalPerN
extends LinkedPersonal {
    final PerN pc;
    final List<Personal> personals;

    public PersonalPerN(Personal link, PerN pc) {
        this(Arrays.asList(link), pc);
    }

    public PersonalPerN(List<Personal> link, PerN pc) {
        super(link.get(0));
        this.pc = pc;
        this.personals = link;
    }

    @Override
    public String describeForSelfBuff() {
        ArrayList<String> strings = new ArrayList<String>();
        for (int i = 0; i < this.personals.size(); ++i) {
            strings.add(this.personals.get(i).describeForSelfBuff());
        }
        return Tann.commaList(strings) + " " + this.pc.describePer();
    }

    @Override
    public boolean showInEntPanelInternal() {
        return false;
    }

    @Override
    public Actor makePanelActorI(boolean big) {
        ArrayList<Actor> actors = new ArrayList<Actor>();
        for (int i = 0; i < this.personals.size(); ++i) {
            actors.add(this.personals.get(i).makePanelActor(big));
        }
        Group a = Tann.layoutMinArea(actors, 3, 999, 999);
        return DipPanel.makeSidePanelGroup((Actor)new Pixl(2).text("x").actor(this.pc.makePanelActor()).pix(), a, Colours.grey);
    }

    @Override
    public List<Personal> getLinkedTriggers(Snapshot snapshot, EntState entState) {
        int amt = this.pc.getAmt(snapshot, entState);
        ArrayList<Personal> result = new ArrayList<Personal>();
        for (int i = 0; i < amt; ++i) {
            result.addAll(this.personals);
        }
        return result;
    }

    @Override
    public float getPriority() {
        return this.personals.get(0).getPriority();
    }

    @Override
    public long getCollisionBits(Boolean player) {
        long result = this.pc.getCollisionBits(player) | super.getCollisionBits(player);
        for (int i = 0; i < this.personals.size(); ++i) {
            result |= this.personals.get(i).getCollisionBits(player);
        }
        return result;
    }

    @Override
    public boolean isMultiplable() {
        return false;
    }

    public static Personal basicMultiple(int n, Personal p) {
        return new PersonalPerN(p, (PerN)new PerNFlat(n));
    }

    @Override
    public Personal genMult(int mult) {
        ArrayList<Personal> ps = new ArrayList<Personal>();
        boolean good = false;
        for (Personal personal : this.personals) {
            Personal gm = personal.genMult(mult);
            if (gm == null) {
                ps.add(personal);
                continue;
            }
            ps.add(gm);
            good = true;
        }
        if (!good) {
            return super.genMult(mult);
        }
        return new PersonalPerN(ps, this.pc);
    }
}

