/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels.book.page.helpPage;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.tann.dice.Main;
import com.tann.dice.screens.dungeon.DungeonUtils;
import com.tann.dice.screens.dungeon.panels.book.page.helpPage.YoutuberPanel;
import com.tann.dice.statics.Images;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Draw;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Rectactor;
import com.tann.dice.util.Tann;
import com.tann.dice.util.listener.TannListener;
import com.tann.dice.util.ui.standardButton.StandardButton;
import java.text.Normalizer;

public class LanguageThing {
    public static Actor makeLanguageSection(YoutuberPanel.Language l, int contentWidth) {
        switch (l) {
            case English: {
                return LanguageThing.makeSimpleTranslated(contentWidth, YoutuberPanel.Language.English, "Sorry, the game is only available in English. It will be difficult if you can't read English text well.", "There are icons for some things, for example", "+3 max hp", "replace the right two sides of the dice with 2-damage attacks", "this button bottom-left will undo most things- try experimenting");
            }
            case Korean: {
                return LanguageThing.makeSimpleTranslated(contentWidth, YoutuberPanel.Language.Korean, "joesonghabnida. geim-eun yeong-eoloman jegongdoebnida. yeong-eo wonmun-eul jal ilgji moshamyeon eolyeoul geos-ibnida.", "yeleul deul-eo myeoch gaji hangmog-e daehan aikon-i issseubnida.", "+3 choedae HP", "jusawiui oleunjjog yangmyeon-eul 2demiji gong-gyeog-eulo gyoche", "oenjjog hadan-e issneun i beoteun-eun daebubun-ui jag-eob-eul chwisohabnida. silheomhae boseyo.");
            }
            case Japanese: {
                return LanguageThing.makeSimpleTranslated(contentWidth, YoutuberPanel.Language.Japanese, "M\u014dshiwakearimasenga, g\u0113mu wa eigo de nomi riy\u014d kan\u014ddesu. Eigo no tekisuto o yoku yomenaito muzukash\u012bdeshou.", "Tatoeba, ikutsu ka no aikon ga arimasu", "+3 Saidai HP", "Saikoro no migi 2-men o 2 dam\u0113ji k\u014dgeki ni okikaeru", "Kono hidarishita no botan wa hotondo no koto o gen ni modoshimasu - jikken shite mite kudasai");
            }
            case German: {
                return LanguageThing.makeSimpleTranslated(contentWidth, YoutuberPanel.Language.German, "Entschuldigung, das Spiel ist nur auf Englisch verf\u00fcgbar. Schwierig wird es, wenn Sie \u00fcberhaupt keinen englischen Text lesen k\u00f6nnen.", "Es gibt zum Beispiel Symbole f\u00fcr einige Dinge", "+3 max hp", "Ersetzen Sie die beiden rechten Seiten des W\u00fcrfels durch Angriffe mit 2 Schadenspunkten", "Diese Schaltfl\u00e4che unten links macht die meisten Dinge r\u00fcckg\u00e4ngig - versuchen Sie es mit Experimenten");
            }
            case French: {
                return LanguageThing.makeSimpleTranslated(contentWidth, YoutuberPanel.Language.French, "D\u00e9sol\u00e9, le jeu n'est disponible qu'en anglais. Ce sera difficile si vous ne pouvez pas bien lire le texte anglais.", "Il y a des ic\u00f4nes pour certaines choses, par exemple", "+3 HP maximum", "remplacer les deux c\u00f4t\u00e9s droits des d\u00e9s par des attaques \u00e0 2 d\u00e9g\u00e2ts", "ce bouton en bas \u00e0 gauche annulera la plupart des choses - essayez d'exp\u00e9rimenter");
            }
            case Spanish: {
                return LanguageThing.makeSimpleTranslated(contentWidth, YoutuberPanel.Language.Spanish, "Lo sentimos, el juego solo est\u00e1 disponible en ingl\u00e9s. Ser\u00e1 dif\u00edcil si no puedes leer bien el texto en ingl\u00e9s.", "Hay iconos para algunas cosas, por ejemplo", "+3 hp m\u00e1x", "reemplaza los dos lados derechos de los dados con ataques de 2 da\u00f1os", "este bot\u00f3n en la parte inferior izquierda deshar\u00e1 la mayor\u00eda de las cosas; intente experimentar");
            }
            case Russian: {
                return LanguageThing.makeSimpleTranslated(contentWidth, YoutuberPanel.Language.Russian, "\u041a \u0441\u043e\u0436\u0430\u043b\u0435\u043d\u0438\u044e, \u0438\u0433\u0440\u0430 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430 \u0442\u043e\u043b\u044c\u043a\u043e \u043d\u0430 \u0430\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u043e\u043c \u044f\u0437\u044b\u043a\u0435. \u0411\u0443\u0434\u0435\u0442 \u0441\u043b\u043e\u0436\u043d\u043e, \u0435\u0441\u043b\u0438 \u0432\u044b \u043f\u043b\u043e\u0445\u043e \u0447\u0438\u0442\u0430\u0435\u0442\u0435 \u0430\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439 \u0442\u0435\u043a\u0441\u0442.", "\u0415\u0441\u0442\u044c \u0438\u043a\u043e\u043d\u043a\u0438 \u0434\u043b\u044f \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u0432\u0435\u0449\u0435\u0439, \u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440", "+3 \u043c\u0430\u043a\u0441 \u0445\u043f", "\u0437\u0430\u043c\u0435\u043d\u0438\u0442\u0435 \u043f\u0440\u0430\u0432\u044b\u0435 \u0434\u0432\u0435 \u0441\u0442\u043e\u0440\u043e\u043d\u044b \u043a\u0443\u0431\u0438\u043a\u0430 \u0430\u0442\u0430\u043a\u0430\u043c\u0438 \u0441 2 \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f\u043c\u0438", "\u044d\u0442\u0430 \u043a\u043d\u043e\u043f\u043a\u0430 \u0432\u043d\u0438\u0437\u0443 \u0441\u043b\u0435\u0432\u0430 \u043e\u0442\u043c\u0435\u043d\u0438\u0442 \u0431\u043e\u043b\u044c\u0448\u0438\u043d\u0441\u0442\u0432\u043e \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0439 - \u043f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u043f\u043e\u044d\u043a\u0441\u043f\u0435\u0440\u0438\u043c\u0435\u043d\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c", false);
            }
            case Portuguese: {
                return LanguageThing.makeSimpleTranslated(contentWidth, YoutuberPanel.Language.Portuguese, "Desculpe, o jogo s\u00f3 est\u00e1 dispon\u00edvel em ingl\u00eas. Ser\u00e1 dif\u00edcil se voc\u00ea n\u00e3o conseguir ler bem o texto em ingl\u00eas.", "Existem \u00edcones para algumas coisas, por exemplo", "+3 hp m\u00e1ximo", "substitua os dois lados direitos dos dados por ataques de 2 de dano", "este bot\u00e3o no canto inferior esquerdo ir\u00e1 desfazer a maioria das coisas - tente experimentar");
            }
            case Chinese: {
                return LanguageThing.makeSimpleTranslated(contentWidth, YoutuberPanel.Language.Chinese, "B\u00e0oqi\u00e0n, g\u0101i y\u00f3ux\u00ec j\u01d0n t\u00edg\u014dng y\u012bngw\u00e9n b\u01cenb\u011bn. R\u00fagu\u01d2 n\u01d0 b\u00f9n\u00e9ng h\u011bn h\u01ceo de yu\u00e8d\u00fa y\u012bngw\u00e9n w\u00e9nb\u011bn, zh\u00e8 ji\u0101ng sh\u00ec k\u00f9nn\u00e1n de.", "Y\u01d2uxi\u0113 d\u014dngx\u012b y\u01d2u t\u00fabi\u0101o, l\u00ecr\u00fa", "+3 zu\u00ecd\u00e0 m\u01cel\u00ec", "ji\u0101ng sh\u01ceizi de y\u00f2u c\u00e8 li\u01ceng c\u00e8 t\u00echu\u00e0n w\u00e8i 2 sh\u0101ngh\u00e0i g\u014dngj\u00ed", "zh\u00e8ge zu\u01d2xi\u00e0 ji\u01ceo de \u00e0nni\u01d4 ji\u0101ng ch\u00e8xi\u0101o d\u00e0 du\u014dsh\u00f9 sh\u00ecq\u00edng - ch\u00e1ngsh\u00ec sh\u00ecy\u00e0n");
            }
        }
        return LanguageThing.makeSimpleTranslated(contentWidth, YoutuberPanel.Language.English, "err", "err", "err", "err", "err");
    }

    private static Actor makeSimpleTranslated(int contentWidth, YoutuberPanel.Language language, String topLine, String iconography, String threeMax, String replaceSides, String undo) {
        return LanguageThing.makeSimpleTranslated(contentWidth, language, topLine, iconography, threeMax, replaceSides, undo, true);
    }

    private static Actor makeSimpleTranslated(int contentWidth, YoutuberPanel.Language language, String topLine, String iconography, String threeMax, String replaceSides, String undo, boolean strip) {
        int rectWidth = contentWidth - 6;
        if (strip) {
            topLine = LanguageThing.fixLang(topLine);
            iconography = LanguageThing.fixLang(iconography);
            threeMax = LanguageThing.fixLang(threeMax);
            replaceSides = LanguageThing.fixLang(replaceSides);
            undo = LanguageThing.fixLang(undo);
        }
        topLine = "[text]" + topLine;
        iconography = "[text]" + iconography;
        threeMax = "[text]" + threeMax;
        replaceSides = "[text]" + replaceSides;
        undo = "[text]" + undo;
        Group youtubers = new Pixl(1).rowedActors(language.makeYoutuberPanels()).pix();
        return new Pixl(2).text(topLine, (int)((float)contentWidth - youtubers.getWidth() - 34.0f)).gap(7).actor(youtubers).row().actor(new Rectactor(rectWidth, 1, Colours.grey)).row().image(Images.hack_undo).text(undo, (int)((double)contentWidth * 0.5)).pix();
    }

    private static String fixLang(String text) {
        return Normalizer.normalize(text, Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "");
    }

    public static Actor makeGlobeButton() {
        Actor ia = DungeonUtils.makeBasicButton(Images.globe);
        ia.addListener(new TannListener(){

            @Override
            public boolean action(int button, int pointer, float x, float y) {
                Actor a = LanguageThing.makeLanguageContainer();
                Sounds.playSound(Sounds.pip);
                Main.getCurrentScreen().push(a, 0.8f);
                Tann.center(a);
                return true;
            }
        });
        return ia;
    }

    private static Actor makeLanguageContainer() {
        int width = 140;
        Pixl p = new Pixl(4, 4).border(Colours.blue);
        for (final YoutuberPanel.Language l : YoutuberPanel.Language.values()) {
            StandardButton sb = new StandardButton(l.getColourTaggedCode());
            sb.setRunnable(new Runnable(){

                @Override
                public void run() {
                    LanguageThing.showLanguagePanel(l);
                }
            });
            p.actor(sb, 140.0f);
        }
        return p.pix();
    }

    private static void showLanguagePanel(YoutuberPanel.Language l) {
        if (l == YoutuberPanel.Language.Chinese) {
            LanguageThing.showChinesePage();
            return;
        }
        Sounds.playSound(Sounds.pip);
        Group a = new Pixl(0, 3).border(Colours.blue).actor(LanguageThing.makeLanguageSection(l, (int)((float)Main.width * 0.8f))).pix();
        Main.getCurrentScreen().push(a, true, true, false, 0.8f);
        Tann.center(a);
    }

    private static void showChinesePage() {
        final Texture guide = new Texture(Gdx.files.internal("guide/chinese.png"));
        Sounds.playSound(Sounds.pip);
        Group chineseMiddleSection = new Group(){

            @Override
            public void draw(Batch batch, float parentAlpha) {
                Main.self().stop2d(true);
                SpriteBatch bg = Main.self().startBackground();
                int scale = Main.scale;
                Draw.scaleRegion((Batch)bg, guide, (int)this.getX() * scale, (int)this.getY() * scale, (int)this.getWidth() * scale, (int)this.getHeight() * scale);
                Main.self().stopBackground();
                Main.self().start2d(true);
                super.draw(batch, parentAlpha);
            }
        };
        float ratio = (float)guide.getWidth() / (float)guide.getHeight();
        int maxWidth = (int)((float)Main.width * 0.9f);
        int maxHeight = (int)((float)Main.height * 0.9f);
        int width = (int)Math.min((float)maxWidth, (float)maxHeight * ratio);
        int height = (int)((float)width * (1.0f / ratio));
        chineseMiddleSection.setSize(width, height);
        float linkCenterX = 0.44f;
        float linkCenterY = 0.92f;
        float linkWidth = 0.43f;
        float linkHeight = 0.11f;
        Actor clickable = new Actor();
        clickable.setSize((int)((float)width * linkWidth), (int)((float)height * linkHeight));
        chineseMiddleSection.addActor(clickable);
        clickable.setPosition(chineseMiddleSection.getWidth() * (linkCenterX - linkWidth / 2.0f), chineseMiddleSection.getHeight() * (linkCenterY - linkHeight / 2.0f));
        clickable.addListener(new TannListener(){

            @Override
            public boolean action(int button, int pointer, float x, float y) {
                Main.getCurrentScreen().openUrl("https://www.bilibili.com/video/BV163411B7BU/");
                return true;
            }
        });
        Group cont = new Pixl(0, 1).border(Colours.grey).actor(chineseMiddleSection).pix();
        Main.getCurrentScreen().push(cont, 0.8f);
        Tann.center(cont);
    }
}

