/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels.combatEffects.crush;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.tann.dice.gameplay.content.ent.Ent;
import com.tann.dice.gameplay.fightLog.FightLog;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.screens.dungeon.panels.combatEffects.CombatEffectActor;
import com.tann.dice.screens.dungeon.panels.entPanel.EntPanel;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Draw;
import com.tann.dice.util.Tann;

public class CrushActor
extends CombatEffectActor {
    final boolean top;
    final Ent target;
    final TextureRegion img;

    public CrushActor(boolean top, Ent target, TextureRegion img) {
        this.top = top;
        this.target = target;
        this.img = img;
        this.setSize(img.getRegionWidth(), img.getRegionHeight());
    }

    @Override
    protected void start(FightLog fightLog) {
        EntPanel panel = this.target.getEntPanel();
        Vector2 panelLoc = Tann.getAbsoluteCoordinates(panel);
        this.setX((int)(panelLoc.x + panel.getWidth() / 2.0f - this.getWidth() / 2.0f));
        int targetY = (int)(panelLoc.y - this.getHeight() * 0.5f);
        if (this.top) {
            targetY = (int)((float)targetY + panel.getHeight());
        }
        int dist = 45;
        this.setY(targetY + dist * (this.top ? 1 : -1));
        this.addAction(Actions.sequence((Action)Actions.moveTo(this.getX(), targetY, this.getImpactDuration(), Interpolation.pow2In), (Action)Actions.parallel((Action)Actions.run(new Runnable(){

            @Override
            public void run() {
                Sounds.playSound(Sounds.clangs);
            }
        }), (Action)Actions.moveBy(0.0f, 5 * (this.top ? 1 : -1), this.getExtraDuration()), (Action)Actions.fadeOut(this.getExtraDuration()))));
        DungeonScreen.get().addActor(this);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        batch.setColor(this.getColor());
        Draw.drawScaled(batch, this.img, this.getX(), this.getY() + (this.top ? 0.0f : this.getHeight()), 1.0f, this.top ? 1.0f : -1.0f);
        super.draw(batch, parentAlpha);
    }

    @Override
    protected float getImpactDuration() {
        return 0.35f;
    }

    @Override
    protected float getExtraDuration() {
        return 0.3f;
    }
}

