/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels.combatEffects.simpleProjectile.arrow;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.Ent;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.screens.dungeon.panels.combatEffects.simpleProjectile.SimpleAbstractProjectile;
import com.tann.dice.screens.dungeon.panels.entPanel.EntPanel;
import com.tann.dice.statics.ImageUtils;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Tann;

public class ArrowActor
extends SimpleAbstractProjectile {
    private static final TextureRegion arrow = ImageUtils.loadExt("combatEffects/projectile/arrow");
    float magnitude;
    public static final float WIGGLE_FREQ = 42.0f;
    public static final float START_MAGNITUDE = 28.0f;
    public static final float MAGNITUDE_DECAY = 82.0f;
    boolean impacted;
    boolean nowDead;
    Vector2 endPos;
    private static Vector2 tmp = new Vector2();

    public ArrowActor(Ent source, Ent target, int damage, boolean nowDead) {
        super(source, target, damage, 0.24f);
        this.nowDead = nowDead;
        this.setTouchable(Touchable.disabled);
    }

    @Override
    protected void internalStart() {
        Sounds.playSound(Sounds.arrowFly, 1.0f, 1.0f);
    }

    @Override
    protected TextureRegion getImage() {
        return arrow;
    }

    @Override
    protected void arrowImpact() {
        if (!this.dodged) {
            if (this.blocked) {
                Sounds.playSound(Sounds.clangs);
            } else {
                Sounds.playSound(Sounds.arrowWobble);
            }
        }
        this.magnitude = 28.0f;
        this.target.getEntPanel().addActor(this);
        DungeonScreen.get().addCleanupActor(this);
        Vector2 onPanelLocation = this.getOnPanelLocation();
        this.setPosition(onPanelLocation.x, onPanelLocation.y);
        this.impacted = true;
        if (this.nowDead) {
            Tann.addBlood(Main.getCurrentScreen(), this.target.getSize().getNumBlood(), (int)(this.endPos.x + (float)arrow.getRegionWidth()), 3.0f, (int)this.endPos.y, 5.0f, -12.5f, 7.5f, 0.0f, 9.0f);
        }
    }

    @Override
    protected void setupTargetVector(EntPanel targetPan) {
        super.setupTargetVector(targetPan);
        if (this.nowDead) {
            this.endPos = Tann.getAbsoluteCoordinates(targetPan).add(targetPan.getPortraitCenter()).sub(arrow.getRegionWidth(), 0.0f).cpy();
            this.endX = (int)this.endPos.x;
            this.endY = (int)this.endPos.y;
            return;
        }
        int tries = 4;
        float bestDist = 0.0f;
        int bestX = 0;
        int bestY = 0;
        for (int i = 0; i < tries; ++i) {
            super.setupTargetVector(targetPan);
            Vector2 onPanelLocation = this.getOnPanelLocation();
            float worstDist = 9999.0f;
            for (Actor a : targetPan.getChildren()) {
                float dist;
                if (!(a instanceof ArrowActor) || !((dist = onPanelLocation.dst(a.getX(), a.getY())) < worstDist)) continue;
                worstDist = dist;
            }
            if (!(worstDist > bestDist)) continue;
            bestDist = worstDist;
            bestX = this.endX;
            bestY = this.endY;
        }
        this.endX = bestX;
        this.endY = bestY;
    }

    public Vector2 getOnPanelLocation() {
        Vector2 panelPos = Tann.getAbsoluteCoordinates(this.target.getEntPanel());
        tmp.set((float)this.endX - panelPos.x, (float)this.endY - panelPos.y);
        return tmp;
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        if (this.impacted) {
            if (this.dodged) {
                this.remove();
            }
            this.magnitude -= 82.0f * delta;
            if (this.magnitude < 0.0f) {
                this.magnitude = 0.0f;
                if (this.blocked || Main.isPortrait()) {
                    this.remove();
                }
            }
        }
    }

    @Override
    protected float getImpactDuration() {
        return super.getImpactDuration();
    }

    @Override
    protected float getExtraDuration() {
        return 0.34146342f;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        float rotation = this.currentTravel < this.travelTime ? this.travelRotation : (float)(Math.sin(Main.secs * 42.0f) * (double)this.magnitude) + (float)(this.player ? 0 : 180);
        batch.setColor(this.getColor());
        batch.draw(this.getImage(), (int)this.getX(), (int)this.getY(), this.getImage().getRegionWidth(), (float)this.getImage().getRegionHeight() / 2.0f, this.getImage().getRegionWidth(), this.getImage().getRegionHeight(), 1.0f, 1.0f, rotation);
    }
}

