/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels.entPanel;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.Ent;
import com.tann.dice.gameplay.content.ent.EntSize;
import com.tann.dice.gameplay.content.ent.Monster;
import com.tann.dice.gameplay.content.ent.StateCache;
import com.tann.dice.gameplay.content.ent.die.Die;
import com.tann.dice.gameplay.content.ent.die.DieContainer;
import com.tann.dice.gameplay.effect.Trait;
import com.tann.dice.gameplay.effect.eff.EffType;
import com.tann.dice.gameplay.effect.eff.keyword.Keyword;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.fightLog.FightLog;
import com.tann.dice.gameplay.fightLog.Snapshot;
import com.tann.dice.gameplay.fightLog.event.entState.StateEvent;
import com.tann.dice.gameplay.phase.PhaseManager;
import com.tann.dice.gameplay.save.settings.option.OptionLib;
import com.tann.dice.gameplay.trigger.personal.Personal;
import com.tann.dice.gameplay.trigger.personal.merge.Merge;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.screens.dungeon.TargetingManager;
import com.tann.dice.screens.dungeon.panels.entPanel.DieHolder;
import com.tann.dice.screens.dungeon.panels.entPanel.ShieldHolder;
import com.tann.dice.screens.dungeon.panels.entPanel.TriggerPanel;
import com.tann.dice.screens.dungeon.panels.entPanel.choosablePanel.ConcisePanel;
import com.tann.dice.screens.dungeon.panels.entPanel.heartsHolder.HPHolder;
import com.tann.dice.screens.dungeon.panels.tutorial.TutorialManager;
import com.tann.dice.statics.Images;
import com.tann.dice.statics.bullet.BulletStuff;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Draw;
import com.tann.dice.util.ShakeAction;
import com.tann.dice.util.SpeechBubble;
import com.tann.dice.util.SpeechGarbler;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannFont;
import com.tann.dice.util.TextWisp;
import com.tann.dice.util.listener.MultitapListener;
import com.tann.dice.util.ui.TextWriter;
import java.util.ArrayList;
import java.util.List;

public class EntPanel
extends Group
implements DieContainer {
    public Ent ent;
    public boolean holdsDie = false;
    public HPHolder HPHolder;
    static final int n = 5;
    static NinePatch panelBorder = new NinePatch(Images.panelBorder, 5, 5, 5, 5);
    static NinePatch panelBorderSmall = new NinePatch(Images.panelBorderSmall, 5, 5, 5, 5);
    static NinePatch panelBorderLeft = new NinePatch(Images.panelBorderLeft, 5, 5, 5, 5);
    static NinePatch panelBorderRight = new NinePatch(Images.panelBorderRight, 5, 5, 5, 5);
    static NinePatch panelBorderRightHighlight = new NinePatch(Images.panelBorderRightHighlight, 5, 5, 5, 5);
    static NinePatch panelBorderColour = new NinePatch(Images.panelBorderColour, 5, 5, 5, 5);
    public static final float WIDTH = 84.0f;
    int borderSize = 4;
    int textBorderSize = 3;
    private final int gap;
    boolean huge;
    private static final float MIN_SHAKE_TIME = 0.2f;
    private static final float SHAKE_EXTRA = 0.2f;
    private ShieldHolder shieldHolder;
    private List<Actor> underneathActors = new ArrayList<Actor>();
    private StateCache stateCache;
    public DieHolder dieHolder;
    private boolean highlightDice;
    Vector2 portraitPosition = new Vector2();
    List<Ent> targets = new ArrayList<Ent>();
    List<Color> tmpColours = new ArrayList<Color>();
    private boolean possibleTarget;
    private List<Keyword> possibleTargetBonus;
    float fadeSpeed = 0.0f;
    private float intensity;
    boolean slidOutToTarget;
    int stateEventIndex = 0;
    boolean animating;
    List<Personal> describables;
    private static final long TIME_BETWEEN_BUBBLES = 2000L;
    private static long lastSpeechBubble;
    List<Actor> overActors = new ArrayList<Actor>();
    int preferredY = 10;
    Actor marginActor;
    float savedMargin = -1.0f;

    public EntPanel(final Ent ent) {
        this.setTransform(false);
        this.ent = ent;
        this.stateCache = new StateCache(ent, FightLog.Temporality.Visual, FightLog.Temporality.Present, FightLog.Temporality.Future);
        if (ent.getSize() == EntSize.small) {
            this.gap = 1;
            this.borderSize = 2;
            this.textBorderSize = 2;
        } else {
            this.gap = 2;
        }
        this.huge = ent.getSize() == EntSize.huge;
        this.addListener(new MultitapListener(){

            @Override
            public boolean info(int button, float x, float y) {
                DungeonScreen ds = DungeonScreen.get();
                if (ds != null) {
                    ds.targetingManager.clicked(EntPanel.this.ent, false);
                    ds.getTutorialManager().onAction(ent.isPlayer() ? TutorialManager.TutorialAction.HeroPanelInfo : TutorialManager.TutorialAction.MonsterPanelInfo, ent);
                    return true;
                }
                return false;
            }

            @Override
            public boolean action(int button, int pointer, float x, float y) {
                DungeonScreen ds = DungeonScreen.get();
                if (ds != null) {
                    if (!ent.isPlayer()) {
                        ds.getTutorialManager().onAction(TutorialManager.TutorialAction.SelectMonster);
                    }
                    ds.targetingManager.clicked(EntPanel.this.ent, true);
                }
                return true;
            }
        });
        this.setPosition(0.0f, Main.height);
    }

    public void addUnderneathActor(Actor actor) {
        if (actor instanceof Group) {
            ((Group)actor).setTransform(false);
        }
        this.underneathActors.add(actor);
    }

    public void layout() {
        this.clearUnderneathActors();
        this.describables = null;
        this.clearChildren();
        this.HPHolder = new HPHolder(this.ent);
        this.addActor(this.HPHolder);
        int titleSize = 43;
        if (this.ent.getSize() == EntSize.huge) {
            titleSize = 53;
        }
        Actor title = ConcisePanel.makeTitle(this.ent.getName(true, false), this.ent.getColour(), titleSize);
        this.addActor(title);
        this.setWidth(84.0f);
        if (this.huge) {
            this.setHeight((float)(this.ent.getPixelSize() + this.gap * 2) + title.getHeight() + 18.0f + (float)(this.borderSize * 2));
        } else {
            this.setHeight(this.ent.getPixelSize() + this.borderSize * 2);
        }
        TriggerPanel buffHolder = new TriggerPanel(this.ent, false);
        this.addActor(buffHolder);
        this.dieHolder = new DieHolder(this.ent);
        this.addActor(this.dieHolder);
        boolean player = this.ent.isPlayer();
        this.dieHolder.setY(this.borderSize);
        title.setY((int)(this.getHeight() - (float)this.textBorderSize - (float)TannFont.font.getHeight()));
        this.HPHolder.setY((int)(title.getY() - (float)this.gap - this.HPHolder.getHeight()));
        int heartsMiddleX = 0;
        if (player) {
            this.dieHolder.setX(this.getWidth() - (float)this.borderSize - this.dieHolder.getWidth());
            heartsMiddleX = Tann.between(this.ent.getPortraitWidth(true), this.dieHolder.getX() - (float)this.borderSize - 1.0f) - 1;
        } else {
            this.dieHolder.setX(this.borderSize);
            if (this.huge) {
                heartsMiddleX = (int)Math.max(title.getWidth() / 2.0f + 3.0f, 8.0f + this.HPHolder.getWidth() / 2.0f);
            } else {
                heartsMiddleX = Tann.between(this.dieHolder.getX() + this.dieHolder.getWidth() + (float)this.borderSize, this.getWidth() - (float)this.ent.getPortraitWidth(true));
                int minX = (int)(this.dieHolder.getX() + this.dieHolder.getWidth() + buffHolder.getWidth() + this.HPHolder.getWidth() / 2.0f) + 1;
                heartsMiddleX = Math.max(minX, heartsMiddleX);
            }
        }
        if (!(this.ent.getSize() != EntSize.small && this.ent.getSize() != EntSize.reg || this.HPHolder.smallPips())) {
            heartsMiddleX = 38;
        }
        title.setX((int)((float)(heartsMiddleX += this.ent.getPortraitShift()) - (title.getWidth() / 2.0f - 0.5f)));
        this.HPHolder.setX((int)((float)heartsMiddleX - (this.HPHolder.getWidth() / 2.0f - 0.5f)));
        int buffHolderX = !this.ent.isPlayer() ? (int)(this.HPHolder.getX() - buffHolder.getWidth() - 1.0f) : (int)(this.HPHolder.getX() + this.HPHolder.getWidth() + 1.0f);
        EntSize size = this.ent.getEntType().size;
        int buffHolderY = this.HPHolder.smallPips() && (size == EntSize.big || size == EntSize.reg) ? (int)(this.HPHolder.getY() + this.HPHolder.getHeight() - buffHolder.getHeight()) : (int)(this.HPHolder.getY() + this.HPHolder.getHeight() - buffHolder.getHeight());
        buffHolder.setPosition(buffHolderX, buffHolderY);
        this.shieldHolder = new ShieldHolder(this.ent);
        this.shieldHolder.setPosition(this.getShieldHolderPosition(1.0f), (int)(this.getHeight() / 2.0f - this.shieldHolder.getHeight() / 2.0f));
        this.addActor(this.shieldHolder);
        if (this.savedMargin != -1.0f) {
            this.setMargin(this.savedMargin);
        }
    }

    private void clearUnderneathActors() {
        this.underneathActors.clear();
    }

    private int getShieldHolderPosition(float dist) {
        boolean small = ShieldHolder.useSmallShieldHolder();
        if (this.ent.isPlayer()) {
            return (int)(this.getWidth() + this.shieldHolder.getWidth() * (dist - 1.0f) + (float)(small ? -5 : 3));
        }
        return (int)(-this.shieldHolder.getWidth() + this.shieldHolder.getWidth() * (1.0f - dist) + (float)(small ? 3 : -5));
    }

    public float getPreferredX() {
        if (this.animating) {
            return this.getX();
        }
        int deadAmount = (int)(this.getWidth() + 20.0f);
        if (this.ent.getState(FightLog.Temporality.Visual).isDead()) {
            return this.ent.isPlayer() ? (float)(-deadAmount) : (float)deadAmount;
        }
        if (this.ent.isPlayer()) {
            return this.slidOutToTarget ? BulletStuff.getPanelSlideAmount() : 0;
        }
        if (this.ent.getFightLog().anyHidingVisual() && this.ent.getState(FightLog.Temporality.Visual).isForwards()) {
            return -BulletStuff.getPanelSlideAmount();
        }
        return 0.0f;
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        this.updatePanelStateCache();
        this.tickUnderneathActors(this.underneathActors, delta);
        this.tickUnderneathActors(this.overActors, delta);
        if (this.fadeSpeed > 0.0f) {
            this.intensity = Math.max(0.0f, this.intensity - delta * this.fadeSpeed);
        }
    }

    public void updatePanelStateCache() {
        EntState oldVisual = this.stateCache.get(FightLog.Temporality.Visual);
        EntState oldFuture = this.stateCache.get(FightLog.Temporality.Future);
        if (this.stateCache.update()) {
            this.describables = null;
            this.setNewVisualState(oldVisual, this.stateCache.get(FightLog.Temporality.Visual));
            this.setNewFutureState(oldFuture, this.stateCache.get(FightLog.Temporality.Future));
        }
    }

    private void tickUnderneathActors(List<Actor> actors, float delta) {
        for (int i = actors.size() - 1; i >= 0; --i) {
            Actor a = actors.get(i);
            a.act(delta);
            if (!(a.getColor().a <= 0.0f)) continue;
            actors.remove(a);
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        this.drawUnderneathActors(batch);
        int x = (int)Math.floor(this.getX());
        int y = (int)Math.floor(this.getY());
        batch.setColor(Colours.dark);
        this.drawCutout(batch);
        if (this.stateCache.get(FightLog.Temporality.Visual).isDead()) {
            Draw.fillActor(batch, this);
        }
        batch.setColor(Colours.z_white);
        int npWiggle = 1;
        int borderX = (int)(this.dieHolder.getX() + (this.ent.isPlayer() ? (float)(-this.borderSize) : this.dieHolder.getWidth() + (float)this.borderSize - 1.0f));
        if (!this.ent.isPlayer()) {
            NinePatch pb = panelBorder;
            if (this.ent.getSize() == EntSize.small) {
                pb = panelBorderSmall;
            }
            pb.draw(batch, x - npWiggle, y - npWiggle, this.getWidth() + (float)(npWiggle * 2), this.getHeight() + (float)(npWiggle * 2));
        } else {
            panelBorderRight.draw(batch, x + borderX, y - npWiggle, this.getWidth() - (float)borderX + (float)npWiggle, this.getHeight() + (float)(npWiggle * 2));
            panelBorderLeft.draw(batch, x - npWiggle, y - npWiggle, borderX + npWiggle * 2, this.getHeight() + (float)(npWiggle * 2));
        }
        if (this.shouldDeathFlash()) {
            batch.setColor(EntPanel.getDeathFlashColour(this.isFleeing()));
            this.drawCutout(batch);
        }
        if (this.ent.isPlayer()) {
            batch.setColor(this.ent.getColour());
            panelBorderRightHighlight.draw(batch, x + borderX, y - npWiggle, this.getWidth() - (float)borderX + (float)npWiggle, this.getHeight() + (float)(npWiggle * 2));
        }
        TargetingManager targetingManager = null;
        if (DungeonScreen.get() != null) {
            targetingManager = DungeonScreen.get().targetingManager;
        }
        if (targetingManager != null) {
            if (this.possibleTarget) {
                if (!Main.getSettings().isHasSworded() && targetingManager.getSelectedTargetable() != null && targetingManager.getSelectedTargetable().getBaseEffect().getType() == EffType.Damage) {
                    batch.setColor(Colours.withAlpha(Colours.green, Main.pulsateFactor() * 0.4f));
                    Draw.fillRectangle(batch, x - npWiggle, y - npWiggle, this.getWidth() + (float)(npWiggle * 2), this.getHeight() + (float)(npWiggle * 2));
                }
                batch.setColor(Colours.light);
                panelBorderColour.draw(batch, x - npWiggle, y - npWiggle, this.getWidth() + (float)(npWiggle * 2), this.getHeight() + (float)(npWiggle * 2));
                if (this.possibleTargetBonus != null && this.possibleTargetBonus.size() > 0) {
                    int thickness = 2;
                    for (int i = 0; i < this.possibleTargetBonus.size(); ++i) {
                        this.drawPossibleTargetRectangle(batch, this.possibleTargetBonus.get(i).getColour(), i * 2, i * 2 + 2 - 1);
                    }
                }
            } else if (this.ent.isPlayer() && PhaseManager.get().getPhase() != null && PhaseManager.get().getPhase().canTarget() && targetingManager.getSelectedTargetable() == null && this.stateCache.get(FightLog.Temporality.Present).canUse() && targetingManager.isUsable(this.ent.getDie().getTargetable(), true)) {
                if (!Main.getSettings().isHasSworded() && this.ent.getDie().getCurrentSide().getBaseEffect().getType() == EffType.Damage) {
                    batch.setColor(Colours.withAlpha(Colours.green, Main.pulsateFactor() * 0.7f));
                    Draw.fillRectangle(batch, x + borderX, y - npWiggle, this.getWidth() - (float)borderX + (float)npWiggle, this.getHeight() + (float)(npWiggle * 2));
                }
                batch.setColor(Colours.light);
                panelBorderRightHighlight.draw(batch, x + borderX, y - npWiggle, this.getWidth() - (float)borderX + (float)npWiggle, this.getHeight() + (float)(npWiggle * 2));
            }
        }
        if (this.isHighlightDice()) {
            batch.setColor(Colours.light);
            int border = 1;
            panelBorderColour.draw(batch, this.getX() - (float)border, this.getY() - (float)border, this.getWidth() + (float)(border * 2), this.getHeight() + (float)(border * 2));
        }
        this.drawArrows(batch);
        if (!this.ent.isPlayer()) {
            this.drawTargetingBox(batch, 0, 4);
            this.drawTargetingBox(batch, 1, 6);
            this.drawTargetingBox(batch, 2, 8);
        }
        batch.setColor(Colours.z_white);
        TextureAtlas.AtlasRegion region = this.ent.entType.portrait;
        if (region != null) {
            Vector2 portraitDraw = this.getPortraitPosition();
            Draw.drawScaled(batch, region, (float)x + portraitDraw.x, (float)y + portraitDraw.y, this.ent.isPlayer() ? 1.0f : -1.0f, 1.0f);
        }
        super.draw(batch, parentAlpha);
        this.drawBuffs(batch);
        Die.DieState dieState = this.ent.getDie().getState();
        if (dieState == Die.DieState.Rolling || this.stateCache.get(FightLog.Temporality.Present).isSummonedSoNotAttacking() && !this.ent.isPlayer() && Main.getCurrentScreen() instanceof DungeonScreen) {
            batch.setColor(this.ent.getColour());
            int gap = 0;
            float holderX = this.getX() + this.dieHolder.getX() + (float)gap;
            float holderY = this.getY() + this.dieHolder.getY() + (float)gap;
            Draw.fillRectangle(batch, holderX, holderY, this.dieHolder.getWidth() - (float)(gap * 2), this.dieHolder.getWidth() - (float)(gap * 2));
            batch.setColor(Colours.dark);
            gap = 1;
            Draw.fillRectangle(batch, this.getX() + this.dieHolder.getX() + (float)gap, this.getY() + this.dieHolder.getY() + (float)gap, this.dieHolder.getWidth() - (float)(gap * 2), this.dieHolder.getWidth() - (float)(gap * 2));
            batch.setColor(Colours.z_white);
            batch.draw(this.ent.get2DLapel(), holderX, holderY);
        }
    }

    private void drawPossibleTargetRectangle(Batch batch, Color col, int from, int to) {
        batch.setColor(Colours.withAlpha(col, 0.5f + Main.pulsateFactor() * 0.5f));
        for (int i = from; i <= to; ++i) {
            Draw.drawRectangle(batch, (int)this.getX() - i, (int)this.getY() - i, this.getWidth() + (float)(i * 2), this.getHeight() + (float)(i * 2), 1);
        }
    }

    private boolean isHighlightDice() {
        return this.highlightDice;
    }

    public void setHighlightDice(boolean highlightDice) {
        this.highlightDice = highlightDice;
    }

    private Vector2 getPortraitPosition() {
        int offsetX = this.ent.getPortraitOffsetX();
        int offsetY = this.ent.getPortraitOffsetY();
        if (this.ent.isPlayer()) {
            return this.portraitPosition.set(offsetX, offsetY);
        }
        return this.portraitPosition.set(this.getWidth() + (float)offsetX, offsetY);
    }

    public Vector2 getPortraitCenter() {
        int portraitWidth = this.ent.getPortraitWidth(false);
        int portraitHeight = this.ent.getPortrait().getRegionHeight();
        return this.getPortraitPosition().add((float)portraitWidth * (this.ent.isPlayer() ? 0.5f : -0.5f), portraitHeight / 2);
    }

    private void drawBuffs(Batch batch) {
        List<Personal> triggers = this.stateCache.get(FightLog.Temporality.Visual).getActiveTriggers();
        for (int i = 0; i < triggers.size(); ++i) {
            triggers.get(i).drawOnPanel(batch, this);
        }
    }

    private void drawUnderneathActors(Batch batch) {
        if (this.underneathActors.size() > 0) {
            for (Actor a : this.underneathActors) {
                a.draw(batch, 1.0f);
            }
        }
    }

    private void setupTargeters() {
        FightLog.Temporality t = FightLog.Temporality.Present;
        if (this.stateCache.get(t).getSnapshot() == null) {
            return;
        }
        this.targets = new ArrayList<Ent>(this.stateCache.get(t).getSnapshot().getAllTargeters(this.ent, false));
    }

    private void drawTargetingBox(Batch batch, int dist, int gap) {
        this.tmpColours.clear();
        for (int i = 0; i < this.targets.size(); ++i) {
            Ent de = this.targets.get(i);
            if (!de.isPlayer()) continue;
            this.tmpColours.add(de.getColour());
        }
        boolean recWidth = true;
        int h = (int)(this.getHeight() - (float)(gap * 2));
        for (int i = 0; i < this.tmpColours.size(); ++i) {
            batch.setColor(this.tmpColours.get(i));
            Draw.fillRectangle(batch, (int)(this.getX() - (float)recWidth - (float)dist), (int)(this.getY() + (float)gap), (float)recWidth, (float)h - (float)i * (1.0f / (float)this.tmpColours.size()) * (float)h);
        }
    }

    private void drawCutout(Batch batch) {
        int x = (int)this.getX();
        int y = (int)this.getY();
        int gap = 1;
        Draw.fillRectangle(batch, x + gap, y + gap, this.dieHolder.getX() - (float)gap, this.getHeight() - (float)(gap * 2));
        Draw.fillRectangle(batch, (float)x + this.dieHolder.getX(), y, this.dieHolder.getWidth(), this.dieHolder.getY());
        Draw.fillRectangle(batch, (float)x + this.dieHolder.getX(), (float)y + this.dieHolder.getY() + this.dieHolder.getHeight(), this.dieHolder.getWidth(), this.getHeight() - this.dieHolder.getY() - this.dieHolder.getHeight());
        Draw.fillRectangle(batch, (float)x + this.dieHolder.getX() + this.dieHolder.getWidth(), y + gap, this.getWidth() - this.dieHolder.getX() - this.dieHolder.getWidth() - (float)gap, this.getHeight() - (float)(gap * 2));
    }

    public void setPossibleTarget(boolean b) {
        this.setPossibleTarget(b, null);
    }

    public void setPossibleTarget(boolean b, List<Keyword> bonus) {
        this.possibleTarget = b;
        this.possibleTargetBonus = bonus;
    }

    @Override
    public Vector2 getDieHolderLocation(boolean instantUpdate) {
        Vector2 retn = Tann.getAbsoluteCoordinates(this.dieHolder);
        retn.x = (int)retn.x;
        retn.y = (int)retn.y;
        if (instantUpdate) {
            retn.y += this.getPreferredY() - this.getY();
        }
        return retn;
    }

    @Override
    public void startLockingDie() {
        this.holdsDie = true;
    }

    @Override
    public void lockDie() {
        this.ent.getDie().flatDraw = true;
    }

    @Override
    public void unlockDie() {
        this.holdsDie = false;
    }

    public void drawBackground(Batch batch) {
        Vector2 loc = this.getDieHolderLocation(false);
        loc.x = (int)loc.x;
        loc.y = (int)loc.y;
        if (this.hasParent()) {
            batch.setColor(this.dieHolder.getColor());
            Draw.drawRectangle(batch, loc.x, loc.y, this.dieHolder.getWidth(), this.dieHolder.getHeight(), 1);
            int middle = 1;
            batch.setColor(Colours.dark);
            Draw.fillRectangle(batch, (int)(loc.x + (float)middle), (int)(loc.y + (float)middle), (int)(this.dieHolder.getWidth() - (float)(middle * 2)), (int)(this.dieHolder.getHeight() - (float)(middle * 2)));
        }
    }

    private void drawArrows(Batch batch) {
        if (this.intensity == 0.0f || this.getParent() == null) {
            return;
        }
        Snapshot s = this.stateCache.get(FightLog.Temporality.Present).getSnapshot();
        if (s == null) {
            return;
        }
        List<Ent> targs = s.getAllTargeters(this.ent, this.ent.isPlayer());
        if (targs.size() == 0) {
            return;
        }
        batch.setColor(Colours.withAlpha(this.ent.getColour(), this.intensity));
        for (Ent de : targs) {
            Monster m;
            if (de.isPlayer() == this.ent.isPlayer()) continue;
            EntPanel ep = de.getEntPanel();
            if (de.isPlayer()) {
                batch.setColor(Colours.withAlpha(de.getColour(), this.intensity));
            }
            Vector2 me = new Vector2(this.getX(), this.getY());
            Vector2 them = Tann.getAbsoluteCoordinates(ep);
            them.x -= this.getParent().getX();
            them.y -= this.getParent().getY();
            if (de instanceof Monster) {
                m = (Monster)de;
            } else if (this.ent instanceof Monster) {
                m = (Monster)this.ent;
            } else {
                return;
            }
            if (m.getDie().getCurrentSide() == null) continue;
            float width = Math.max(1, m.getDie().getCurrentSide().getBaseEffect().getValue()) + 1;
            width = Math.min(40.0f, width);
            float segmentSize = 5.0f;
            float gapSize = 2.0f;
            float speed = 2.0f;
            if (this.ent.isPlayer()) {
                Draw.drawDottedLine(batch, them.x, them.y + ep.getHeight() / 2.0f, me.x + this.getWidth(), me.y + this.getHeight() / 2.0f, width, segmentSize, gapSize, speed);
                continue;
            }
            Draw.drawDottedLine(batch, me.x, me.y + this.getHeight() / 2.0f, them.x + ep.getWidth(), them.y + ep.getHeight() / 2.0f, width, segmentSize, gapSize, speed);
        }
    }

    public void setArrowIntensity(float intensity, float fadeSpeed) {
        this.intensity = intensity;
        this.fadeSpeed = fadeSpeed;
    }

    public void slideOutToTarget() {
        this.slidOutToTarget = true;
        Tann.finishAllActions(this);
        this.addAction(Actions.moveTo(this.getPreferredX(), this.getPreferredY(), 0.3f, Interpolation.pow2Out));
    }

    public void slideBack() {
        this.slidOutToTarget = false;
        this.addAction(Actions.moveTo(this.getPreferredX(), this.getPreferredY(), 0.3f, Interpolation.pow2Out));
    }

    public void shakeShield() {
        this.shieldHolder.shake();
    }

    public void breakShield() {
        this.shieldHolder.crack();
    }

    public void showVisualDamage(EntState oldState, EntState newState, float shakeFactor, boolean allowShake) {
        if (DungeonScreen.get().isLoading()) {
            return;
        }
        this.HPHolder.addDamageFlibs(oldState, newState);
        if (allowShake) {
            this.addAction(new ShakeAction(8.0f * shakeFactor, 20.0f, 0.2f + 0.2f * shakeFactor, Interpolation.linear));
        }
    }

    public void showNewBlockedDamage(EntState newState, int blocked) {
        if (newState.isDead()) {
            return;
        }
        if (newState.getShields() > 0) {
            this.shakeShield();
        } else {
            this.breakShield();
        }
    }

    public void showSpikes() {
        if (this.ent.getState(FightLog.Temporality.Present).isDead()) {
            return;
        }
        Sounds.playSound(Sounds.spike);
        Group spikeGroup = Tann.makeGroup();
        spikeGroup.setWidth(Images.spike.getRegionWidth());
        int numSpikes = 1;
        for (int i = 0; i < numSpikes; ++i) {
            Image image = new Image(Images.spike);
            image.setSize(Images.spike.getRegionWidth(), Images.spike.getRegionHeight());
            spikeGroup.addActor(image);
            if (this.ent.isPlayer()) {
                image.setX(this.getWidth() - image.getWidth());
            } else {
                image.setScale(-1.0f, 1.0f);
                image.setX(image.getWidth());
            }
            image.setY((int)(this.getHeight() * 1.0f / 3.0f - image.getHeight() / 2.0f));
        }
        Vector2 absPos = Tann.getAbsoluteCoordinates(this);
        spikeGroup.setPosition(spikeGroup.getX() + absPos.x, spikeGroup.getY() + absPos.y);
        spikeGroup.addAction(Actions.sequence((Action)Actions.moveBy(spikeGroup.getWidth() * (float)(this.ent.isPlayer() ? 1 : -1), 0.0f, 0.1f, Interpolation.pow2Out), (Action)Actions.delay(0.3f), (Action)Actions.moveBy(spikeGroup.getWidth() * (float)(this.ent.isPlayer() ? -1 : 1), 0.0f, 0.5f, Interpolation.pow2Out), (Action)Actions.alpha(0.0f)));
        this.addUnderneathActor(spikeGroup);
    }

    public void setNewVisualState(EntState oldState, EntState newState) {
        int newDamageBlocked;
        boolean newStun;
        int hpChange;
        this.shieldHolder.reset();
        if (oldState == null) {
            return;
        }
        if (oldState.getMaxHp() != newState.getMaxHp()) {
            this.layout();
        }
        if (oldState.getShields() < newState.getShields()) {
            this.shieldHolder.flash();
        }
        if ((hpChange = newState.getHp() - oldState.getHp()) > 0) {
            this.HPHolder.addHeartFlibs(oldState, newState);
        }
        boolean bl = newStun = !oldState.isStunned() && newState.isStunned();
        if (hpChange < 0 || newStun) {
            float shakeFactor = Math.min(1.0f, (float)(-hpChange) / (float)newState.getMaxHp());
            if (newStun) {
                shakeFactor += 0.4f;
            }
            this.showVisualDamage(oldState, newState, shakeFactor, true);
        }
        if ((newDamageBlocked = newState.getDamageBlocked() - oldState.getDamageBlocked()) > 0) {
            this.showNewBlockedDamage(newState, newDamageBlocked);
        }
        if (oldState.isDead() != newState.isDead()) {
            if (newState.isDead()) {
                if (newState.isFled()) {
                    Sounds.playSound(Sounds.flee);
                } else {
                    this.ent.deathSound();
                }
                this.ent.getDie().removeFromScreen();
            } else {
                this.lockDie();
                this.ent.getDie().setupInitialLocation();
                this.ent.getDie().removeFromPhysics();
            }
        }
        this.HPHolder.newState(newState, FightLog.Temporality.Visual);
        List<StateEvent> stateEvents = newState.getStateEvents();
        for (int i = this.stateEventIndex; i < stateEvents.size(); ++i) {
            stateEvents.get(i).act(this);
        }
        this.stateEventIndex = stateEvents.size();
    }

    public void addMessage(String text) {
        if (DungeonScreen.get().isLoading()) {
            return;
        }
        TextWisp tw = new TextWisp(text, 0, 6, 0.5f);
        this.addActor(tw);
        tw.setPosition((int)(this.getWidth() / 2.0f - tw.getWidth() / 2.0f), (int)(this.getHeight() / 2.0f - tw.getHeight() / 2.0f));
    }

    public void setNewFutureState(EntState oldFutureState, EntState newFutureState) {
        this.setupTargeters();
        if (oldFutureState == null) {
            return;
        }
        this.HPHolder.newState(newFutureState, FightLog.Temporality.Future);
    }

    public void setAnimating(boolean animating) {
        this.animating = animating;
    }

    public List<Personal> getAllDescribableTriggers() {
        if (this.describables == null) {
            EntState visual = this.stateCache.get(FightLog.Temporality.Visual);
            EntState future = this.stateCache.get(FightLog.Temporality.Future);
            this.describables = new ArrayList<Personal>();
            this.describables.addAll(future.getActiveTriggers());
            int visualAddIndex = 0;
            for (Personal personal : visual.getActiveTriggers()) {
                if (this.describables.contains(personal)) {
                    visualAddIndex = this.describables.indexOf(personal) + 1;
                    continue;
                }
                boolean canMerge = false;
                for (Personal f : this.describables) {
                    if (!(f instanceof Merge) || !((Merge)f).canMerge(personal) || !personal.buff.canMerge(f.buff)) continue;
                    canMerge = true;
                    break;
                }
                if (canMerge) continue;
                this.describables.add(visualAddIndex++, personal);
            }
            for (int i = this.describables.size() - 1; i >= 0; --i) {
                Trait trait = this.describables.get(i).getTrait();
                if (trait != null && trait.visible || this.describables.get(i).showInEntPanel() || this.describables.get(i).showInDiePanel()) continue;
                this.describables.remove(i);
            }
        }
        return this.describables;
    }

    public void addSpeechBubble(String chatText) {
        EntState vis = this.stateCache.get(FightLog.Temporality.Visual);
        for (Personal activeTrigger : vis.getActiveTriggers()) {
            chatText = activeTrigger.transformChat(chatText, vis);
        }
        if (this.ent.getColour() == Colours.green) {
            chatText = SpeechGarbler.garble(this.ent, chatText);
        }
        long now = System.currentTimeMillis();
        if (DungeonScreen.get().isLoading() || !OptionLib.TRIPLE_CHAT.c() && this.ent.isPlayer() && now - lastSpeechBubble < 2000L) {
            return;
        }
        lastSpeechBubble = now;
        SpeechBubble sb = new SpeechBubble(TextWriter.getTag(this.ent.getColour()) + chatText, !this.ent.isPlayer());
        sb.setColor(this.ent.getColour());
        Vector2 portraitCenter = this.getPortraitCenter();
        portraitCenter.add(9 * (this.ent.isPlayer() ? 1 : -1), -4.0f);
        this.addActor(sb);
        sb.setPosition((int)portraitCenter.x, (int)portraitCenter.y);
        Vector2 actualPos = Tann.getAbsoluteCoordinates(sb, Tann.TannPosition.Top);
        if (actualPos.y > (float)Main.height) {
            sb.setY((int)(sb.getY() - (actualPos.y - (float)Main.height)));
        }
        sb.addAction(Actions.sequence((Action)Actions.delay(1.4f, Actions.fadeOut(0.2f)), (Action)Actions.removeActor()));
    }

    public void postDraw(Batch batch) {
        if (!this.hasParent()) {
            return;
        }
        for (int i = 0; i < this.overActors.size(); ++i) {
            Actor a = this.overActors.get(i);
            Vector2 myPos = Tann.getAbsoluteCoordinates(this);
            Tann.intify(myPos);
            a.setPosition(a.getX() + myPos.x, a.getY() + myPos.y);
            a.draw(batch, 1.0f);
            a.setPosition(a.getX() - myPos.x, a.getY() - myPos.y);
        }
    }

    public void setPreferredY(int prefY) {
        this.preferredY = prefY;
    }

    public float getPreferredY() {
        return this.preferredY;
    }

    public boolean shouldDeathFlash() {
        return this.stateCache.get(FightLog.Temporality.Future).isDead() && !this.stateCache.get(FightLog.Temporality.Visual).isDead();
    }

    private boolean isFleeing() {
        return this.stateCache.get(FightLog.Temporality.Future).isFled();
    }

    public static Color getDeathFlashColour(boolean flee) {
        return Colours.withAlpha(flee ? Colours.grey : Colours.red, 0.2f + Main.pulsateFactor() * 0.5f);
    }

    public void setMargin(float margin) {
        this.savedMargin = margin;
        if (this.marginActor != null) {
            this.marginActor.remove();
        }
        if (margin < 0.0f) {
            return;
        }
        float maxGap = 10.0f;
        margin = Math.min(margin, maxGap);
        this.marginActor = new Actor(){};
        this.marginActor.setSize(this.getWidth() + margin, this.getHeight() + margin * 2.0f);
        this.addActor(this.marginActor);
        this.marginActor.setPosition(-margin, -margin);
    }
}

