/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels.entPanel.heartsHolder;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.tann.dice.screens.dungeon.panels.entPanel.heartsHolder.HPHolder;
import com.tann.dice.statics.Images;
import com.tann.dice.util.Colours;
import com.tann.dice.util.tp.TP;
import java.util.HashMap;
import java.util.Map;

public class PipData {
    int reds;
    int greens;
    int yellows;
    int purples;
    int max;
    final Map<Integer, TP<TextureRegion, Color>> specials = new HashMap<Integer, TP<TextureRegion, Color>>();

    public void reset() {
        int def;
        this.reds = def = -1;
        this.greens = def;
        this.yellows = def;
        this.purples = def;
        this.max = def;
        this.specials.clear();
    }

    public void set(int reds, int greens, int yellows, int purples) {
        this.reds = reds;
        this.greens = greens;
        this.yellows = yellows;
        this.purples = purples;
        this.max = reds + greens + yellows + purples;
    }

    public void addSpecialPip(int hpIndex, TP<TextureRegion, Color> pipTannple) {
        if (this.specials.get(hpIndex) == null) {
            this.specials.put(hpIndex, pipTannple);
        } else {
            this.specials.put(hpIndex, new TP<TextureRegion, Color>(Images.hp_glider, Colours.pink));
        }
    }

    public Color getCol(int i) {
        TP<TextureRegion, Color> spec = this.specials.get(i);
        if ((i -= this.reds) < 0) {
            return spec == null ? Colours.red : (Color)spec.b;
        }
        if ((i -= this.greens) < 0) {
            return Colours.green;
        }
        if ((i -= this.yellows) < 0) {
            return Colours.yellow;
        }
        if ((i -= this.purples) < 0) {
            return Colours.purple;
        }
        return Colours.pink;
    }

    public TextureRegion getImage(int i, HPHolder.PipSize pipSize) {
        if (pipSize == HPHolder.PipSize.normal && this.specials.get(i) != null) {
            return (TextureRegion)this.specials.get((Object)Integer.valueOf((int)i)).a;
        }
        if (this.getCol(i) == Colours.purple) {
            switch (pipSize) {
                case normal: {
                    return Images.hp_empty;
                }
                case little: {
                    return Images.hp_empty_small;
                }
                case pixel: {
                    return pipSize.img;
                }
            }
        }
        return pipSize.img;
    }
}

