/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels.hourglass;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.fightLog.Snapshot;
import com.tann.dice.gameplay.trigger.Trigger;
import com.tann.dice.gameplay.trigger.global.Global;
import com.tann.dice.gameplay.trigger.personal.Personal;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.screens.dungeon.DungeonUtils;
import com.tann.dice.screens.dungeon.panels.hourglass.HourglassElement;
import com.tann.dice.screens.dungeon.panels.hourglass.HourglassTime;
import com.tann.dice.statics.Images;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Draw;
import com.tann.dice.util.ImageActor;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import com.tann.dice.util.listener.TannListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class HourglassUtils {
    public static List<HourglassElement> getHourglassItems(Snapshot present) {
        ArrayList<HourglassElement> result = new ArrayList<HourglassElement>();
        for (Global g : present.getGlobals()) {
            HourglassElement items = HourglassUtils.getHourglassItems(g);
            if (items == null) continue;
            result.add(items);
        }
        List<EntState> sts = present.getStates(true, false);
        for (int stsi = 0; stsi < sts.size(); ++stsi) {
            EntState es = sts.get(stsi);
            List<Personal> ps = es.getActiveTriggers();
            for (int i = 0; i < ps.size(); ++i) {
                HourglassElement he = HourglassUtils.getHourglassItems(ps.get(i), es.getEnt().getName(true) + "[p]: ");
                if (he == null) continue;
                result.add(he);
            }
        }
        return result;
    }

    public static HourglassElement getHourglassItems(Trigger t) {
        return HourglassUtils.getHourglassItems(t, null);
    }

    public static HourglassElement getHourglassItems(Trigger t, String pref) {
        HourglassElement hge = t.hourglassUtil();
        if (hge == null) {
            return null;
        }
        if (pref != null) {
            hge.message = pref + hge.message;
        }
        return hge;
    }

    public static boolean hourglassShouldBeHighlit(Snapshot present, List<HourglassElement> items) {
        for (HourglassElement item : items) {
            if (!item.hourglassShouldBeHighlit(present)) continue;
            return true;
        }
        return false;
    }

    public static Actor makeHourglassButton(final Snapshot present) {
        List<HourglassElement> hourglassItems = HourglassUtils.getHourglassItems(present);
        int turn = present.getTurn();
        final HashMap levelToGlasses = new HashMap();
        boolean anyActive = false;
        for (HourglassElement hourglassItem : hourglassItems) {
            List<Integer> ints = hourglassItem.getTurns(turn);
            if (ints == null) continue;
            anyActive = true;
            for (Integer integer : ints) {
                if (integer == 0) continue;
                if (levelToGlasses.get(integer) == null) {
                    levelToGlasses.put(integer, new ArrayList());
                }
                ((List)levelToGlasses.get(integer)).add(hourglassItem);
            }
        }
        if (hourglassItems.isEmpty() || !anyActive) {
            return null;
        }
        final boolean highlit = HourglassUtils.hourglassShouldBeHighlit(present, hourglassItems);
        ImageActor butt = new ImageActor(DungeonUtils.getBaseImage()){

            @Override
            public void draw(Batch batch, float parentAlpha) {
                super.draw(batch, parentAlpha);
                TextureRegion tr = highlit ? Images.hourglassActive : Images.hourglass;
                Draw.draw(batch, tr, (float)((int)(this.getX() + this.getWidth() / 2.0f - (float)(tr.getRegionWidth() / 2))), (float)((int)(this.getY() + this.getHeight() / 2.0f - (float)(tr.getRegionHeight() / 2))));
            }
        };
        butt.addListener(new TannListener(){

            @Override
            public boolean action(int button, int pointer, float x, float y) {
                Sounds.playSound(Sounds.pip);
                int width = 90;
                Pixl p = new Pixl(2, 3).border(Colours.grey);
                p.text("[text]Current turn: [yellow]" + present.getTurn());
                for (Integer level : levelToGlasses.keySet()) {
                    List allForLevel = (List)levelToGlasses.get(level);
                    HashMap timeElementMapForTurn = new HashMap();
                    for (HourglassTime time : HourglassTime.values()) {
                        ArrayList<HourglassElement> elemsForTime = new ArrayList<HourglassElement>();
                        timeElementMapForTurn.put(time, elemsForTime);
                        for (HourglassElement hourglassElement : allForLevel) {
                            if (hourglassElement.hourglassTime != time) continue;
                            elemsForTime.add(hourglassElement);
                        }
                    }
                    for (HourglassTime time : HourglassTime.values()) {
                        String endText;
                        List elems = (List)timeElementMapForTurn.get((Object)time);
                        if (elems.isEmpty()) continue;
                        Pixl levelInner = new Pixl(2, 2).border(Colours.grey);
                        switch (time) {
                            case START: {
                                endText = "[grey] (start)[cu][p]";
                                break;
                            }
                            case END: {
                                endText = "[grey] (end)[cu][p]";
                                break;
                            }
                            default: {
                                endText = "";
                            }
                        }
                        levelInner.text("[text]Turn [yellow]" + level + "[cu]" + endText);
                        for (HourglassElement elem : elems) {
                            levelInner.row().text(elem.getRealMessage(), 90);
                        }
                        p.row().actor(levelInner.pix(8));
                    }
                }
                Group a = p.pix(8);
                DungeonScreen.get().push(a, 0.7f);
                Tann.center(a);
                return true;
            }
        });
        return butt;
    }
}

