/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.shaderFx;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.tann.dice.screens.shaderFx.FXContainer;
import com.tann.dice.screens.shaderFx.ShaderFolder;

public class FXSingularity
extends FXContainer {
    public FXSingularity(Actor group) {
        super(group);
        this.loadShader(ShaderFolder.singularity);
        this.setColor(1.0f, 1.0f, 1.0f, 0.0f);
        this.setScale(0.0f);
        float yRatio = 0.7f;
        this.addAction(Actions.sequence((Action)Actions.scaleTo(0.0f, 1.0f, this.getDuration() * yRatio), (Action)Actions.alpha(1.0f, this.getDuration() * (1.0f - yRatio)), (Action)Actions.removeActor()));
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        ShaderProgram previous = batch.getShader();
        batch.setShader(this.program);
        this.group.setPosition(this.originalPosition.x, this.originalPosition.y);
        this.program.setUniformf("u_random", this.random);
        this.program.setUniformf("u_bounds", this.originalPosition.x, this.originalPosition.y, this.group.getWidth(), this.group.getHeight());
        this.program.setUniformf("u_alpha", this.getColor().a);
        this.program.setUniformf("u_scaleX", this.getScaleX());
        this.program.setUniformf("u_scaleY", this.getScaleY());
        this.group.draw(batch, 1.0f);
        batch.setShader(previous);
        super.draw(batch, parentAlpha);
    }

    @Override
    public float getDuration() {
        return 0.5f;
    }
}

