/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.statics.sound;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.utils.Array;
import com.tann.dice.Main;
import com.tann.dice.gameplay.save.settings.option.OptionLib;
import com.tann.dice.platform.audio.SoundHandler;
import com.tann.dice.test.util.TestRunner;
import com.tann.dice.util.Tann;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Sounds {
    public static AssetManager am;
    public static Array<Sound> sounds;
    public static String[] clacks;
    public static String[] clocks;
    public static String[] lock;
    public static String[] unlock;
    public static String[] clangs;
    public static String[] punches;
    public static String[] slash;
    public static String[] blocks;
    public static String[] heals;
    public static String[] magic;
    public static String[] spike;
    public static String[] boost;
    public static String[] deboost;
    public static String[] stealth;
    public static String[] smith;
    public static String[] whistle;
    public static String[] song;
    public static String[] onRoll;
    public static String[] undying;
    public static String[] resurrect;
    public static String[] pip;
    public static String[] pipSmall;
    public static String[] pop;
    public static String[] error;
    public static String[] confirm;
    public static String[] undo;
    public static String[] paper;
    public static String[] impacts;
    public static String[] arrowFly;
    public static String[] arrowWobble;
    public static String[] poison;
    public static String[] poisonImpact;
    public static String[] regen;
    public static String[] regenActivate;
    public static String[] dust;
    public static String[] slice;
    public static String[] swing;
    public static String[] lightning;
    public static String[] beam;
    public static String[] fire;
    public static String[] iceExplode;
    public static String[] bitesmall;
    public static String[] biteReg;
    public static String[] biteBig;
    public static String[] biteHuge;
    public static String[] slimeMovesmall;
    public static String[] slimeMoveBig;
    public static String[] slimeMoveHuge;
    public static String[] slam;
    public static String[] tribolt;
    public static String[] bats;
    public static String[] fireBreath;
    public static String[] poisonBreath;
    public static String[] thwack;
    public static String[] summonGeneric;
    public static String[] summonWolf;
    public static String[] summonBones;
    public static String[] summonImp;
    public static String[] deathHero;
    public static String[] deathPew;
    public static String[] deathReg;
    public static String[] deathBig;
    public static String[] deathExplosion;
    public static String[] deathDragonLong;
    public static String[] deathOof;
    public static String[] deathCute;
    public static String[] deathScream;
    public static String[] deathSqueak;
    public static String[] deathAlien;
    public static String[] deathDemon;
    public static String[] deathHorse;
    public static String[] deathSpawn;
    public static String[] deathWeird;
    public static String[] flap;
    public static String[] flee;
    public static String[] surr;
    public static String[] clink;
    public static String[] slime;
    public static String[] gong;
    public static String[] wail;
    public static String[] chip;
    public static String[] defeat;
    public static String[] victory;
    public static String[] chooseItem;
    public static String[] pickup;
    public static String[] drop;
    public static List<String> allStrings;
    private static SoundHandler soundHandler;
    public static HashMap<String, Sound> soundMap;
    static HashMap<String[], Long> timeLastPlayedMap;
    private static final long repeatTime = 50L;
    private static boolean soundEnabled;

    public static void disposeAll() {
        for (Sound s : soundMap.values()) {
            s.dispose();
        }
        Sounds.clearCaches();
    }

    public static void clearCaches() {
        soundMap = new HashMap();
    }

    public static void setup(SoundHandler soundHandler) {
        Sounds.soundHandler = soundHandler;
        am = new AssetManager();
        clacks = Sounds.makeSounds("dice/clack");
        clocks = Sounds.makeSounds("dice/clock");
        lock = Sounds.makeSounds("dice/fwt");
        unlock = Sounds.makeSounds("dice/twf");
        clangs = Sounds.makeSounds("combat/clang");
        impacts = Sounds.makeSounds("combat/impact");
        slash = Sounds.makeSounds("combat/slash");
        swing = Sounds.makeSounds("combat/swing");
        punches = Sounds.makeSounds("combat/punch");
        blocks = Sounds.makeSounds("combat/block");
        heals = Sounds.makeSounds("combat/heal");
        magic = Sounds.makeSounds("combat/mystic");
        boost = Sounds.makeSounds("combat/boost");
        deboost = Sounds.makeSounds("combat/deboost");
        stealth = Sounds.makeSounds("combat/stealth");
        spike = Sounds.makeSounds("combat/spike");
        arrowFly = Sounds.makeSounds("combat/arrowFly");
        arrowWobble = Sounds.makeSounds("combat/arrowWobble");
        slam = Sounds.makeSounds("combat/slam");
        thwack = Sounds.makeSounds("combat/thwack");
        slice = Sounds.makeSounds("combat/spell/slice");
        lightning = Sounds.makeSounds("combat/spell/lightning");
        beam = Sounds.makeSounds("combat/spell/beam");
        fire = Sounds.makeSounds("combat/spell/fire");
        iceExplode = Sounds.makeSounds("combat/spell/iceExplode");
        smith = Sounds.makeSounds("combat/specialSide/smith");
        whistle = Sounds.makeSounds("combat/specialSide/whistle");
        song = Sounds.makeSounds("combat/specialSide/song");
        onRoll = Sounds.makeSounds("combat/specialSide/onRoll");
        undying = Sounds.makeSounds("combat/specialSide/undying");
        resurrect = Sounds.makeSounds("combat/specialSide/resurrect");
        tribolt = Sounds.makeSounds("combat/specialSide/tribolt");
        bats = Sounds.makeSounds("combat/specialSide/bats");
        fireBreath = Sounds.makeSounds("combat/specialSide/fireBreath");
        poisonBreath = Sounds.makeSounds("combat/specialSide/poisonBreath");
        summonWolf = Sounds.makeSounds("combat/specialSide/summon/wolf");
        summonBones = Sounds.makeSounds("combat/specialSide/summon/bones");
        summonGeneric = Sounds.makeSounds("combat/specialSide/summon/generic");
        summonImp = Sounds.makeSounds("combat/specialSide/summon/imp");
        poison = Sounds.makeSounds("combat/poison/poison");
        poisonImpact = Sounds.makeSounds("combat/poison/poisonImpact");
        surr = Sounds.makeSounds("combat/surr/surr");
        regen = Sounds.makeSounds("combat/regen/regen");
        regenActivate = Sounds.makeSounds("combat/regen/regenActivate");
        pip = Sounds.makeSounds("ui/pip");
        pipSmall = Sounds.makeSounds("ui/pipSmall");
        pop = Sounds.makeSounds("ui/pop");
        error = Sounds.makeSounds("ui/error");
        confirm = Sounds.makeSounds("ui/confirm");
        undo = Sounds.makeSounds("ui/undo");
        paper = Sounds.makeSounds("ui/paper");
        dust = Sounds.makeSounds("ui/dust");
        bitesmall = Sounds.makeSounds("combat/bite/biteSmall");
        biteReg = Sounds.makeSounds("combat/bite/biteReg");
        biteBig = Sounds.makeSounds("combat/bite/biteBig");
        biteHuge = Sounds.makeSounds("combat/bite/biteHuge");
        slimeMovesmall = Sounds.makeSounds("combat/slime/slimeMoveSmall");
        slimeMoveBig = Sounds.makeSounds("combat/slime/slimeMoveBig");
        slimeMoveHuge = Sounds.makeSounds("combat/slime/slimeMoveHuge");
        deathHero = Sounds.makeSounds("combat/death/deathHero");
        deathPew = Sounds.makeSounds("combat/death/deathPew");
        deathReg = Sounds.makeSounds("combat/death/deathReg");
        deathBig = Sounds.makeSounds("combat/death/deathBig");
        deathExplosion = Sounds.makeSounds("combat/death/deathExplosion");
        deathDragonLong = Sounds.makeSounds("combat/death/deathDragon");
        deathOof = Sounds.makeSounds("combat/death/deathOof");
        deathCute = Sounds.makeSounds("combat/death/deathCute");
        deathScream = Sounds.makeSounds("combat/death/deathScream");
        deathSqueak = Sounds.makeSounds("combat/death/deathSqueak");
        deathAlien = Sounds.makeSounds("combat/death/deathAlien");
        deathDemon = Sounds.makeSounds("combat/death/deathDemon");
        deathHorse = Sounds.makeSounds("combat/death/deathHorse");
        deathSpawn = Sounds.makeSounds("combat/death/deathSpawn");
        deathWeird = Sounds.makeSounds("combat/death/deathWeird");
        flap = Sounds.makeSounds("combat/effect/flap");
        flee = Sounds.makeSounds("combat/effect/flee");
        clink = Sounds.makeSounds("combat/effect/clink");
        slime = Sounds.makeSounds("combat/effect/slime");
        gong = Sounds.makeSounds("combat/effect/gong");
        wail = Sounds.makeSounds("combat/effect/wail");
        chip = Sounds.makeSounds("combat/effect/chip");
        defeat = Sounds.makeSounds("combat/end/defeat");
        victory = Sounds.makeSounds("combat/end/victory");
        chooseItem = Sounds.makeSounds("ui/choose/item");
        pickup = Sounds.makeSounds("ui/inventory/pickup");
        drop = Sounds.makeSounds("ui/inventory/drop");
        am.finishLoading();
        am.getAll(Sound.class, sounds);
    }

    public static <T> T get(String name, Class<T> type) {
        return am.get(name, type);
    }

    private static String makeSound(String path, Class type) {
        am.load(path, type);
        allStrings.add(path);
        return path;
    }

    private static String[] makeSounds(String path) {
        return Sounds.makeSounds(path, ".wav");
    }

    private static String[] makeSounds(String path, String extension) {
        String s;
        ArrayList<String> validsPaths = new ArrayList<String>();
        for (int i = 0; i < 999 && Gdx.files.internal(s = "sfx/" + path + "_" + i + extension).exists(); ++i) {
            Sounds.makeSound(s, Sound.class);
            validsPaths.add(s);
        }
        return validsPaths.toArray(new String[0]);
    }

    public static void playSound(String string, float volume, float pitch) {
        if (!soundEnabled || TestRunner.isTesting() || OptionLib.sfx.isOff()) {
            return;
        }
        Sound s = soundMap.get(string);
        if (s == null) {
            s = Sounds.get(string, Sound.class);
            soundMap.put(string, s);
        }
        if ((volume *= Main.getSettings().getVolumeSFX()) <= 0.0f) {
            return;
        }
        soundHandler.play(s, volume, pitch);
    }

    public static void playSound(String[] strings) {
        Sounds.playSound(strings, 1.0f, 1.0f);
    }

    public static void playSound(String[] strings, float volume, float pitch) {
        Long l = timeLastPlayedMap.get(strings);
        long now = System.currentTimeMillis();
        if (l != null && now - l < 50L) {
            return;
        }
        timeLastPlayedMap.put(strings, now);
        Sounds.playSound(strings[(int)(Math.random() * (double)strings.length)], volume, pitch);
    }

    public static void playSoundDelayed(final String[] sound, final float volume, final float pitch, float delay) {
        if (!soundEnabled) {
            return;
        }
        Tann.delay(delay, new Runnable(){

            @Override
            public void run() {
                Sounds.playSound(sound, volume, pitch);
            }
        });
    }

    public static void setSoundEnabled(boolean enabled) {
        soundEnabled = enabled;
    }

    static {
        sounds = new Array();
        allStrings = new ArrayList<String>();
        soundMap = new HashMap();
        timeLastPlayedMap = new HashMap();
        soundEnabled = true;
    }
}

