/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.statics.sound.music;

import com.tann.dice.gameplay.save.settings.option.OptionLib;
import com.tann.dice.statics.sound.music.MusicType;
import com.tann.dice.util.Tann;
import java.util.List;

public class MusicData {
    public final String path;
    public final float seconds;
    public final MusicType[] musicTypes;
    public int loop = 1;
    private static final int playlistLookback = 3;
    float extraFade;
    float fadeDurationMultiplier = 1.0f;

    public MusicData(String path, float seconds, MusicType ... musicTypes) {
        this.path = path;
        this.seconds = seconds;
        this.musicTypes = musicTypes;
    }

    public float getRarity(List<MusicData> played) {
        float base = this.getRarity();
        if (played.contains(this)) {
            int sub = Math.max(0, played.size() - 3);
            int index = played.lastIndexOf(this);
            if (index < sub) {
                return base;
            }
            float ratio = ((float)(index - sub) + 1.0f) / 3.0f;
            return base * (1.01f - ratio);
        }
        return base;
    }

    public float getRarity() {
        float commonNess = this.seconds * (float)this.loop + 20.0f;
        if (OptionLib.MUSIC_SELECTION.c() == 0) {
            int mtl = this.musicTypes.length;
            if (mtl == 0) {
                return 0.0f;
            }
            if (Tann.contains(this.musicTypes, MusicType.Forest)) {
                ++mtl;
            }
            commonNess *= (float)mtl;
        }
        return 1.0f / commonNess;
    }

    public String toString() {
        return this.path;
    }

    public MusicData loop(int loops, float extraFade) {
        this.loop = loops;
        this.extraFade = extraFade;
        return this;
    }

    public MusicData fadeSpeed(float v) {
        this.fadeDurationMultiplier = v;
        return this;
    }
}

