/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.util;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.tann.dice.Main;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Draw;

public class InputBlocker
extends Actor {
    public static final float DARK = 0.7f;
    Runnable r;
    private float alpha = 0.0f;
    boolean blockerListen;
    private boolean medium;

    public void setAction(Runnable r) {
        this.r = r;
    }

    public InputBlocker() {
        this.setAction(new Runnable(){

            @Override
            public void run() {
                if (InputBlocker.this.blockerListen) {
                    Main.getCurrentScreen().forcePop();
                }
            }
        });
        this.setSize(Main.width, Main.height);
        this.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (InputBlocker.this.r != null) {
                    InputBlocker.this.r.run();
                }
                Main.getCurrentScreen().popAllLight();
                Sounds.playSound(Sounds.pop);
                event.handle();
                event.stop();
                return true;
            }
        });
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        batch.setColor(Colours.withAlpha(Colours.z_black, this.alpha));
        Draw.fillActor(batch, this);
    }

    public void setActiveClicker(boolean blockerListen) {
        this.blockerListen = blockerListen;
    }

    public void setMedium(boolean medium) {
        this.medium = medium;
    }

    public boolean isMedium() {
        return this.medium;
    }
}

