/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.util;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Draw;

public class Rectactor
extends Actor {
    final Color outer;
    final Color inner;
    final int thickness;

    public Rectactor(int width, int height, Color outer) {
        this(width, height, outer, null);
    }

    public Rectactor(int width, int height, Color outer, Color inner) {
        this(width, height, 1, outer, inner);
    }

    public Rectactor(int width, int height, int thickness, Color col) {
        this(width, height, thickness, col, null);
    }

    public Rectactor(int width, int height, int thickness, Color outer, Color inner) {
        if (outer == null && inner == null) {
            throw new RuntimeException("eep");
        }
        this.setSize(width, height);
        this.outer = outer;
        this.inner = inner;
        this.thickness = thickness;
    }

    public Rectactor(Actor a, Color col) {
        this((int)a.getWidth(), (int)a.getHeight(), null, col);
    }

    public static void fill(Group g, Color outer) {
        Rectactor.fill(g, outer, Colours.dark);
    }

    public static void fill(Group g, Color outer, Color inner) {
        Rectactor ra = new Rectactor((int)g.getWidth(), (int)g.getHeight(), outer, inner);
        g.addActor(ra);
        ra.toBack();
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        if (this.outer == null) {
            Draw.fillActor(batch, (Actor)this, this.inner);
        } else if (this.inner == null) {
            batch.setColor(this.outer);
            Draw.drawRectangle(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.thickness);
        } else {
            Draw.fillActor(batch, this, this.inner, this.outer, this.thickness);
        }
    }
}

