/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.util;

import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.tann.dice.Main;
import com.tann.dice.statics.ImageUtils;
import com.tann.dice.util.Draw;
import com.tann.dice.util.Noise;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TannFont {
    public static boolean GLOBAL_GLITCH = false;
    public static TannFont font = new TannFont(ImageUtils.loadExt("junk/font/font"));
    HashMap<Character, TextureRegion> glyphs = new HashMap();
    HashMap<Character, TextureRegion> boldGlyphs = new HashMap();
    HashMap<Character, TextureRegion> italicsGlyphs = new HashMap();
    Map<Character, List<Character>> kerningPairs = new HashMap<Character, List<Character>>();
    Map<Character, Integer> italicsShiftLeftAfter = new HashMap<Character, Integer>();
    Map<Character, Integer> italicsShiftRightBefore = new HashMap<Character, Integer>();
    public static final int BASE_ITALICS_SHIFT = 1;
    private static final int kerningGap = 1;
    final int[] heights = new int[]{6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6};
    final boolean[] boldConfig = new boolean[]{false, false, false, false, false, true, true, true, true, true, false, false};
    final boolean[] italicsConfig = new boolean[]{false, false, false, false, false, false, false, false, false, false, true, true};
    final String[] chars = new String[]{"abcdefghijklmnopqrstuvwxyz", "ABCDEFGHIJKLMNOPQRSTUVWXYZ", "0123456789.,!?:()[]{}\"+-/_%='@<>\u221e&|;*#$\u00a3\u20ac\u00a5\u20a9^~", "\u0430\u0431\u0432\u0433\u0434\u0435\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044b\u044c\u044d\u044e\u044f", "\u0410\u0411\u0412\u0413\u0414\u0415\u0416\u0417\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042a\u042b\u042c\u042d\u042e\u042f", "abcdefghijklmnopqrstuvwxyz", "ABCDEFGHIJKLMNOPQRSTUVWXYZ", "0123456789.,!?:()\"+-/", "\u0430\u0431\u0432\u0433\u0434\u0435\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044b\u044c\u044d\u044e\u044f", "\u0410\u0411\u0412\u0413\u0414\u0415\u0416\u0417\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042a\u042b\u042c\u042d\u042e\u042f", "abcdefghijklmnopqrstuvwxyz", "ABCDEFGHIJKLMNOPQRSTUVWXYZ"};
    public static float bonusSin = 0.0f;
    private static final float freq = 6.5f;
    private static final float amp = 2.0f;
    private static final float letterAdd = 0.08f;

    public TannFont(TextureRegion font) {
        if (this.heights.length != this.chars.length) {
            throw new RuntimeException("Invalid font data");
        }
        Pixmap p = Draw.getPixmap(font);
        int x = 0;
        int y = 0;
        for (int row = 0; row < this.heights.length; ++row) {
            boolean bold = this.boldConfig[row];
            boolean italics = this.italicsConfig[row];
            block1: for (char c : this.chars[row].toCharArray()) {
                int dx = 0;
                while (true) {
                    boolean empty = true;
                    for (int dy = 0; dy < this.heights[row]; ++dy) {
                        int col = p.getPixel(font.getRegionX() + x + dx, font.getRegionY() + y + dy);
                        if (col == -256 || col == 0) continue;
                        empty = false;
                        break;
                    }
                    if (empty) {
                        HashMap<Character, TextureRegion> g = italics ? this.italicsGlyphs : (bold ? this.boldGlyphs : this.glyphs);
                        g.put(Character.valueOf(c), new TextureRegion(font, x, y, dx, this.heights[row]));
                        x += dx + 1;
                        continue block1;
                    }
                    ++dx;
                }
            }
            x = 0;
            y += this.heights[row] + 1;
        }
        int spaceWidth = 1;
        this.glyphs.put(Character.valueOf(' '), new TextureRegion(font, font.getRegionWidth() - spaceWidth, 0, spaceWidth, 0));
        this.setupKerningPairs();
        this.setupItalicsShifts();
    }

    public static int guessMaxTextLength() {
        return Main.width / 4;
    }

    public static int guessMaxTextLength(float ratio) {
        return (int)((float)(Main.width / 4) * ratio);
    }

    private void setupKerningPairs() {
        this.kerningPairs.put(Character.valueOf('>'), Arrays.asList(Character.valueOf('=')));
        this.kerningPairs.put(Character.valueOf('e'), Arrays.asList(Character.valueOf('a')));
        this.kerningPairs.put(Character.valueOf('h'), Arrays.asList(Character.valueOf('t')));
        this.kerningPairs.put(Character.valueOf('p'), Arrays.asList(Character.valueOf('a')));
        this.kerningPairs.put(Character.valueOf('r'), Arrays.asList(Character.valueOf('d'), Character.valueOf('a')));
    }

    private void setupItalicsShifts() {
        for (char c : "eyadfbuovcwUOCGWQS".toCharArray()) {
            this.italicsShiftRightBefore.put(Character.valueOf(c), 0);
        }
        for (char c : "qTtVOY".toCharArray()) {
            this.italicsShiftRightBefore.put(Character.valueOf(c), 1);
        }
        for (char c : "tpkneomahLQVWROM".toCharArray()) {
            this.italicsShiftLeftAfter.put(Character.valueOf(c), 0);
        }
        for (char c : "swrxcqyuvzgYAPSDB".toCharArray()) {
            this.italicsShiftLeftAfter.put(Character.valueOf(c), 1);
        }
        for (char c : "lfjidJHUFEGIZNCXTK".toCharArray()) {
            this.italicsShiftLeftAfter.put(Character.valueOf(c), 1);
        }
    }

    public void drawString(Batch batch, String text, float x, float y) {
        this.drawString(batch, text, x, y, false);
    }

    public void drawString(Batch batch, String text, float x, float y, boolean fixedWidth) {
        this.drawString(batch, text, x, y, fixedWidth, false, false, false, false, false, false);
    }

    public void drawString(Batch batch, String text, float x, float y, boolean fixedWidth, boolean wiggle, boolean sin, boolean bold, boolean italics, boolean first, boolean glitch) {
        if (text == null) {
            text = "?!?";
        }
        float wiggleNoise = (Main.getNoiseFromTicks() + 1.0f) / 2.0f;
        char prevChar = '`';
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!italics && !bold && this.kerningPairs.get(Character.valueOf(prevChar)) != null && this.kerningPairs.get(Character.valueOf(prevChar)).contains(Character.valueOf(c))) {
                x -= 1.0f;
            }
            prevChar = c;
            TextureRegion t = this.getGlyph(c, bold, italics);
            int plusY = 0;
            if (wiggle && Math.random() * (double)wiggleNoise > 0.5) {
                plusY = (int)(Math.random() * 2.0) - 0;
            }
            if (sin) {
                plusY = (int)(Math.sin((Main.secs + bonusSin) * 6.5f) * 2.0);
                bonusSin += 0.08f;
            }
            if (italics && (!first || i > 0) && this.italicsShiftRightBefore.get(Character.valueOf(c)) != null) {
                x += (float)this.italicsShiftRightBefore.get(Character.valueOf(c)).intValue();
            }
            if (GLOBAL_GLITCH || glitch) {
                float scale = 0.53f;
                float freq = 1.5f;
                float rand = 0.0f;
                float noiseFreq = 0.005f * (float)(glitch ? 3 : 1);
                float noiseScale = 0.72f;
                float noiseZSpeed = 0.5f;
                TextureRegion actuallyDraw = this.getGlyph((char)Math.round((double)text.charAt(i) + (double)0.72f * Noise.noise((double)(x * noiseFreq), (double)(y * noiseFreq), (double)(Main.secs * 0.5f), 2)), bold, italics);
                Draw.draw(batch, actuallyDraw, (float)Math.round(x + (float)t.getRegionWidth() / 2.0f - (float)actuallyDraw.getRegionWidth() / 2.0f), y + (float)plusY);
            } else {
                Draw.draw(batch, t, x, y + (float)plusY);
            }
            x = fixedWidth ? (x += (float)(this.getDefaultWidth() + 1)) : (x += (float)(t.getRegionWidth() + 1));
            if (!italics) continue;
            x -= 1.0f;
            if (this.italicsShiftLeftAfter.get(Character.valueOf(c)) == null) continue;
            x -= (float)this.italicsShiftLeftAfter.get(Character.valueOf(c)).intValue();
        }
    }

    public void drawString(Batch batch, String text, float x, float y, int align) {
        if (align == 1) {
            this.drawString(batch, text, x - (float)(this.getWidth(text) / 2), y - (float)(this.getHeight() / 2), false);
        }
    }

    public int getWidth(String text) {
        return this.getWidth(text, false, false, false);
    }

    public int getWidth(String text, boolean bold, boolean italics, boolean first) {
        if (text == null) {
            return 0;
        }
        int total = 0;
        char prevChar = '`';
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!italics && !bold && this.kerningPairs.get(Character.valueOf(prevChar)) != null && this.kerningPairs.get(Character.valueOf(prevChar)).contains(Character.valueOf(c))) {
                --total;
            }
            if (italics) {
                if (this.italicsShiftLeftAfter.get(Character.valueOf(c)) != null) {
                    total -= this.italicsShiftLeftAfter.get(Character.valueOf(c)).intValue();
                }
                if (!(first && i <= 0 || this.italicsShiftRightBefore.get(Character.valueOf(c)) == null)) {
                    total += this.italicsShiftRightBefore.get(Character.valueOf(c)).intValue();
                }
                if (i < text.length() - 1) {
                    --total;
                }
            }
            prevChar = c;
            TextureRegion t = this.getGlyph(c, bold, italics);
            total += t.getRegionWidth();
            if (i >= text.length() - 1) continue;
            ++total;
        }
        return total;
    }

    private int getDefaultWidth() {
        return 3;
    }

    public int getHeight() {
        return this.heights[0];
    }

    public int getLineHeight() {
        return this.heights[0] + 1;
    }

    public int getSpaceWidth(boolean italics) {
        return italics ? this.getSpaceWidth() - 1 - 0 : this.getSpaceWidth();
    }

    public int getSpaceWidth() {
        return 4;
    }

    public TextureRegion getGlyph(char c) {
        return this.getGlyph(c, false, false);
    }

    private TextureRegion getGlyph(char c, boolean bold, boolean italics) {
        TextureRegion tr = (italics ? this.italicsGlyphs : (bold ? this.boldGlyphs : this.glyphs)).get(Character.valueOf(c));
        if (tr != null) {
            return tr;
        }
        if (italics && this.glyphs.get(Character.valueOf(c)) != null) {
            return this.glyphs.get(Character.valueOf(c));
        }
        return this.glyphs.get(Character.valueOf('?'));
    }

    public boolean hasChar(char c) {
        return this.glyphs.get(Character.valueOf(c)) != null;
    }
}

