/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.util.bsRandom;

import com.tann.dice.util.bsRandom.Checker;
import com.tann.dice.util.bsRandom.Supplier;
import java.util.List;

public abstract class RandomCheck {
    private static final int DEFAULT_MAX_ATTEMPTS = 200;

    public static <T> T checkedRandom(List<T> list, Checker<T> checker, T def) {
        return RandomCheck.checkedRandom(new RandomListSupplier<T>(list), checker, def);
    }

    public static <T> T checkedRandom(Supplier<T> supplier, Checker<T> checker, T def) {
        return RandomCheck.checkedRandom(supplier, checker, 200, def);
    }

    public static <T> T checkedRandom(Supplier<T> supplier, Checker<T> checker, int maxAttempts, T def) {
        for (int i = 0; i < maxAttempts; ++i) {
            T t = supplier.supply();
            if (!checker.check(t)) continue;
            return t;
        }
        return def;
    }

    private static class RandomListSupplier<T>
    implements Supplier {
        final List<T> t;

        public RandomListSupplier(List<T> t) {
            this.t = t;
        }

        public Object supply() {
            return this.t.get((int)(Math.random() * (double)this.t.size()));
        }
    }
}

