/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.util.ui.resolver;

import com.badlogic.gdx.Input;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.type.EntType;
import com.tann.dice.gameplay.content.ent.type.MonsterType;
import com.tann.dice.gameplay.content.gen.pipe.Pipe;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.effect.eff.keyword.KUtils;
import com.tann.dice.gameplay.effect.eff.keyword.Keyword;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.gameplay.modifier.SmallModifierPanel;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.Choosable;
import com.tann.dice.screens.dungeon.panels.Explanel.DiePanel;
import com.tann.dice.screens.dungeon.panels.entPanel.choosablePanel.ItemPanel;
import com.tann.dice.screens.dungeon.panels.entPanel.choosablePanel.ModifierPanel;
import com.tann.dice.util.Colours;
import com.tann.dice.util.ImageActor;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import com.tann.dice.util.listener.TannListener;
import com.tann.dice.util.ui.TextWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class Resolver<T> {
    final int MAX = 150;
    final int BIG_LIMIT = 5;
    final int BIG_LIMIT_ENT = 2;
    private final Comparator<? super T> sorter;

    public Resolver(Comparator<? super T> sorter) {
        this.sorter = sorter;
    }

    public void activate() {
        this.activate(null);
    }

    public void activate(String overrideInputDescription) {
        if (overrideInputDescription == null) {
            overrideInputDescription = this.getOtherOverrideDesc() != null ? this.getColTag() + this.getOtherOverrideDesc() : this.getColTag() + "Search for " + this.getTypeName();
        }
        Main.self().control.textInput(new Input.TextInputListener(){

            @Override
            public void input(String text) {
                Pipe.setupChecks();
                this.doInput(text);
                Pipe.disableChecks();
            }

            private void doInput(String text) {
                Main.getSettings().setLastSearchIfFailed(null);
                boolean resolveToSingle = true;
                Object t = Resolver.this.byName(text);
                if (t != null) {
                    Resolver.this.resolve(t);
                    return;
                }
                List result = Resolver.this.search(text);
                if (result.size() <= 1 && t != null) {
                    Resolver.this.resolve(t);
                    return;
                }
                if (text.startsWith("=")) {
                    Resolver.this.fail(text, "this is likely a list for custom mode, try pressing the 'paste' button there");
                }
                if (result.size() == 0) {
                    Resolver.this.fail(text, "none found");
                } else if (result.size() > 150) {
                    Resolver.this.fail(text, "too many found: " + result.size());
                } else {
                    Resolver.this.resolveList(result);
                }
            }

            @Override
            public void canceled() {
            }
        }, overrideInputDescription, Main.getSettings().getLastSearchIfFailed(), "");
    }

    protected String getOtherOverrideDesc() {
        return null;
    }

    private String getColTag() {
        if (!Main.self().control.allowsColourTextInput()) {
            return "";
        }
        Color col = this.getCol();
        if (col == null) {
            return "";
        }
        return TextWriter.getTag(col);
    }

    protected abstract Color getCol();

    protected abstract String getTypeName();

    public boolean debugSearch(String text) {
        List<T> rz = this.search(text);
        if (rz != null && rz.size() > 0) {
            this.resolveList(rz);
            return true;
        }
        return false;
    }

    public boolean debugResolve(String text) {
        T t = this.byName(text);
        if (t != null) {
            this.resolve(t);
            return true;
        }
        return false;
    }

    protected abstract T byName(String var1);

    protected abstract List<T> search(String var1);

    protected Actor makeActor(T t, boolean big) {
        if (t instanceof Keyword) {
            if (big) {
                return KUtils.makeActor((Keyword)((Object)t), null);
            }
            return Resolver.makeTiny(((Keyword)((Object)t)).getColourTaggedString(), ((Keyword)((Object)t)).getColour());
        }
        if (t instanceof Modifier) {
            Modifier m = (Modifier)t;
            if (big) {
                return new ModifierPanel(m, false);
            }
            SmallModifierPanel smp = new SmallModifierPanel(m);
            return smp;
        }
        if (t instanceof Item) {
            if (big) {
                return new ItemPanel((Item)t, false);
            }
            return new ImageActor(((Item)t).getImage());
        }
        if (t instanceof EntType) {
            if (big) {
                DiePanel dp = new DiePanel(((EntType)t).makeEnt());
                dp.removeDice();
                return dp;
            }
            return new ImageActor((TextureRegion)((EntType)t).portrait, t instanceof MonsterType);
        }
        if (!big && t instanceof Choosable) {
            Choosable ch = (Choosable)t;
            return Resolver.makeTiny(ch.getName(), ch.getColour());
        }
        return new Pixl(3, 3).border(Colours.pink).text(t.getClass().getSimpleName()).pix();
    }

    private static Actor makeTiny(String s, Color col) {
        return new TextWriter(TextWriter.getTag(col) + s, 99, col, 2);
    }

    public abstract void resolve(T var1);

    public void resolveList(List<T> list) {
        Pixl p = new Pixl(2, 2).border(Colours.grey);
        if (this.sorter != null) {
            Collections.sort(list, this.sorter);
        }
        if (list.size() > 0) {
            boolean ent = list.get(0) instanceof EntType;
            final boolean big = list.size() <= (ent ? 2 : 5);
            for (final T t : list) {
                Actor a = this.makeActor(t, big);
                Tann.addListenerFirst(a, new TannListener(){

                    @Override
                    public boolean action(int button, int pointer, float x, float y) {
                        Main.getCurrentScreen().popAllLight();
                        Main.getCurrentScreen().pop(ScrollPane.class);
                        Resolver.this.resolve(t);
                        return true;
                    }

                    @Override
                    public boolean info(int button, float x, float y) {
                        if (!big) {
                            final Actor bigAc = Resolver.this.makeActor(t, true);
                            Main.getCurrentScreen().push(bigAc, 0.8f);
                            Tann.center(bigAc);
                            bigAc.addListener(new TannListener(){

                                @Override
                                public boolean action(int button, int pointer, float x, float y) {
                                    Main.getCurrentScreen().pop(bigAc);
                                    return true;
                                }
                            });
                        }
                        return super.info(button, x, y);
                    }
                });
                p.actor(a, (float)Main.width * 0.5f);
            }
        }
        Group a = p.pix();
        ScrollPane sp = Tann.makeScrollpane(a);
        sp.setHeight(Math.min(sp.getHeight(), a.getHeight()));
        Main.getCurrentScreen().push(sp, true, true, true, 0.8f);
        Tann.center(sp);
    }

    public void fail(String search, String msg) {
        Main.getSettings().setLastSearchIfFailed(search);
        Main.getCurrentScreen().showDialog(msg, Colours.red);
    }
}

